/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.client;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.LivingEntity;

public class JetpackModel<T extends LivingEntity>
extends HumanoidModel<T> {
    private final ModelPart middle;
    private final ModelPart leftCanister;
    private final ModelPart rightCanister;
    private final ModelPart leftTip1;
    private final ModelPart rightTip1;
    private final ModelPart leftExhaust1;
    private final ModelPart leftExhaust2;
    private final ModelPart rightExhaust1;
    private final ModelPart rightExhaust2;
    static final float yOffset = -1.0f;
    static final float xSeparation = 0.6f;

    public JetpackModel(ModelPart model) {
        super(model);
        this.middle = model.m_171324_("middle");
        this.leftCanister = model.m_171324_("leftCanister");
        this.rightCanister = model.m_171324_("rightCanister");
        this.leftTip1 = model.m_171324_("leftTip1");
        this.rightTip1 = model.m_171324_("rightTip1");
        this.leftExhaust1 = model.m_171324_("leftExhaust1");
        this.leftExhaust2 = model.m_171324_("leftExhaust2");
        this.rightExhaust1 = model.m_171324_("rightExhaust1");
        this.rightExhaust2 = model.m_171324_("rightExhaust2");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.8f), (float)0.0f);
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("middle", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 54).m_171481_(-2.0f, 3.0f, 3.6f, 4.0f, 5.0f, 2.0f), PartPose.f_171404_);
        root.m_171599_("leftTip2", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 49).m_171481_(2.1f, -2.0f, 3.6f, 2.0f, 2.0f, 2.0f), PartPose.f_171404_);
        root.m_171599_("rightTip2", CubeListBuilder.m_171558_().m_171480_().m_171514_(17, 49).m_171481_(-4.1f, -2.0f, 3.6f, 2.0f, 2.0f, 2.0f), PartPose.f_171404_);
        root.m_171599_("leftTip1", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 45).m_171481_(1.6f, 0.5f, 3.1f, 3.0f, 1.0f, 3.0f), PartPose.f_171404_);
        root.m_171599_("rightTip1", CubeListBuilder.m_171558_().m_171480_().m_171514_(17, 45).m_171481_(-4.6f, 0.5f, 3.1f, 3.0f, 1.0f, 3.0f), PartPose.f_171404_);
        root.m_171599_("leftCanister", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 32).m_171481_(1.1f, 1.0f, 2.6f, 4.0f, 7.0f, 4.0f), PartPose.f_171404_);
        root.m_171599_("rightCanister", CubeListBuilder.m_171558_().m_171480_().m_171514_(17, 32).m_171481_(-5.1f, 1.0f, 2.6f, 4.0f, 7.0f, 4.0f), PartPose.f_171404_);
        root.m_171599_("leftExhaust1", CubeListBuilder.m_171558_().m_171480_().m_171514_(35, 32).m_171481_(1.6f, 8.0f, 3.1f, 3.0f, 1.0f, 3.0f), PartPose.f_171404_);
        root.m_171599_("rightExhaust1", CubeListBuilder.m_171558_().m_171480_().m_171514_(48, 32).m_171481_(-4.6f, 8.0f, 3.1f, 3.0f, 1.0f, 3.0f), PartPose.f_171404_);
        root.m_171599_("leftExhaust2", CubeListBuilder.m_171558_().m_171480_().m_171514_(35, 37).m_171481_(1.1f, 9.0f, 2.6f, 4.0f, 5.0f, 4.0f), PartPose.f_171404_);
        root.m_171599_("rightExhaust2", CubeListBuilder.m_171558_().m_171480_().m_171514_(35, 46).m_171481_(-5.1f, 9.0f, 2.6f, 4.0f, 5.0f, 4.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        this.middle.m_104315_(this.f_102810_);
        this.leftCanister.m_104315_(this.middle);
        this.rightCanister.m_104315_(this.middle);
        this.leftTip1.m_104315_(this.middle);
        this.rightTip1.m_104315_(this.middle);
        this.leftExhaust1.m_104315_(this.middle);
        this.leftExhaust2.m_104315_(this.middle);
        this.rightExhaust1.m_104315_(this.middle);
        this.rightExhaust2.m_104315_(this.middle);
        return ImmutableList.of((Object)this.f_102810_, (Object)this.middle, (Object)this.leftCanister, (Object)this.rightCanister, (Object)this.leftTip1, (Object)this.rightTip1, (Object)this.leftExhaust1, (Object)this.leftExhaust2, (Object)this.rightExhaust1, (Object)this.rightExhaust2, (Object)this.f_102812_, (Object)this.f_102811_, (Object[])new ModelPart[0]);
    }

    public void m_7695_(PoseStack poseStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        super.m_7695_(poseStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    private static void getJetpackModelFromJson(PartDefinition root) {
        Gson gson = new Gson();
        JsonObject model = null;
        try {
            ResourceLocation location = new ResourceLocation("tjetpacks", "jetpack_model.json");
            Resource resource = (Resource)Minecraft.m_91087_().m_91098_().m_213713_(location).orElseThrow();
            model = (JsonObject)gson.fromJson((Reader)resource.m_215508_(), JsonObject.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load jetpack model!", e);
        }
        JsonArray elements = model.getAsJsonArray("elements");
        for (JsonElement element : elements) {
            JsonObject box = element.getAsJsonObject();
            String name = box.has("name") ? box.get("name").getAsString() : "part";
            JsonArray from = box.getAsJsonArray("from");
            JsonArray to = box.getAsJsonArray("to");
            float x1 = from.get(0).getAsFloat();
            float y1 = from.get(1).getAsFloat();
            float z1 = from.get(2).getAsFloat();
            float x2 = to.get(0).getAsFloat();
            float y2 = to.get(1).getAsFloat();
            float z2 = to.get(2).getAsFloat();
            JsonObject faces = box.getAsJsonObject("faces");
            JsonObject anyFace = ((JsonElement)((Map.Entry)faces.entrySet().iterator().next()).getValue()).getAsJsonObject();
            JsonArray uv = anyFace.getAsJsonArray("uv");
            int texU = Math.round(uv.get(0).getAsFloat());
            int texV = Math.round(uv.get(1).getAsFloat());
            float originX = x1 - 8.0f;
            float originY = y1;
            float originZ = z1;
            int sizeX = Math.round(x2 - x1);
            int sizeY = Math.round(y2 - y1);
            int sizeZ = Math.round(z2 - z1);
            switch (name) {
                case "middle": {
                    root.m_171599_("middle", CubeListBuilder.m_171558_().m_171480_().m_171514_(texU, texV).m_171481_(originX, originY, originZ, (float)sizeX, (float)sizeY, (float)sizeZ), PartPose.f_171404_);
                    break;
                }
                case "leftCanister": {
                    root.m_171599_("leftCanister", CubeListBuilder.m_171558_().m_171480_().m_171514_(texU, texV).m_171481_(originX, originY, originZ, (float)sizeX, (float)sizeY, (float)sizeZ), PartPose.f_171404_);
                    break;
                }
                case "rightCanister": {
                    root.m_171599_("rightCanister", CubeListBuilder.m_171558_().m_171480_().m_171514_(texU, texV).m_171481_(originX, originY, originZ, (float)sizeX, (float)sizeY, (float)sizeZ), PartPose.f_171404_);
                    break;
                }
                case "leftTip1": {
                    root.m_171599_("leftTip1", CubeListBuilder.m_171558_().m_171480_().m_171514_(texU, texV).m_171481_(originX, originY, originZ, (float)sizeX, (float)sizeY, (float)sizeZ), PartPose.f_171404_);
                    break;
                }
                case "rightTip1": {
                    root.m_171599_("rightTip1", CubeListBuilder.m_171558_().m_171480_().m_171514_(texU, texV).m_171481_(originX, originY, originZ, (float)sizeX, (float)sizeY, (float)sizeZ), PartPose.f_171404_);
                    break;
                }
                case "leftExhaust1": {
                    root.m_171599_("leftExhaust1", CubeListBuilder.m_171558_().m_171480_().m_171514_(texU, texV).m_171481_(originX, originY, originZ, (float)sizeX, (float)sizeY, (float)sizeZ), PartPose.f_171404_);
                    break;
                }
                case "rightExhaust1": {
                    root.m_171599_("rightExhaust1", CubeListBuilder.m_171558_().m_171480_().m_171514_(texU, texV).m_171481_(originX, originY, originZ, (float)sizeX, (float)sizeY, (float)sizeZ), PartPose.f_171404_);
                    break;
                }
                case "leftTip2": {
                    root.m_171599_("leftTip2", CubeListBuilder.m_171558_().m_171480_().m_171514_(texU, texV).m_171481_(originX, originY, originZ, (float)sizeX, (float)sizeY, (float)sizeZ), PartPose.f_171404_);
                    break;
                }
                case "rightTip2": {
                    root.m_171599_("rightTip2", CubeListBuilder.m_171558_().m_171480_().m_171514_(texU, texV).m_171481_(originX, originY, originZ, (float)sizeX, (float)sizeY, (float)sizeZ), PartPose.f_171404_);
                    break;
                }
                case "leftExhaust2": {
                    root.m_171599_("leftExhaust2", CubeListBuilder.m_171558_().m_171480_().m_171514_(texU, texV).m_171481_(originX, originY, originZ, (float)sizeX, (float)sizeY, (float)sizeZ), PartPose.f_171404_);
                    break;
                }
                case "rightExhaust2": {
                    root.m_171599_("rightExhaust2", CubeListBuilder.m_171558_().m_171480_().m_171514_(texU, texV).m_171481_(originX, originY, originZ, (float)sizeX, (float)sizeY, (float)sizeZ), PartPose.f_171404_);
                }
            }
        }
    }
}

