/*
 * Decompiled with CFR 0.152.
 */
package jetpacks;

import jetpacks.RegistryHandler;
import jetpacks.client.ui.HUDHandler;
import jetpacks.config.ModConfig;
import jetpacks.handlers.ClientJetpackHandler;
import jetpacks.handlers.CommonJetpackHandler;
import jetpacks.handlers.KeybindHandler;
import jetpacks.integration.CuriosIntegration;
import jetpacks.item.JetpackItem;
import jetpacks.item.ModItemGroup;
import jetpacks.item.PilotGogglesItem;
import jetpacks.network.NetworkHandler;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosCapability;

@Mod(value="tjetpacks")
public class ThermalJetpacks {
    public static final String MOD_ID = "tjetpacks";
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TAB = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"tjetpacks");
    public static final Logger LOGGER = LogManager.getLogger();

    public ThermalJetpacks() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.register((Object)new HUDHandler()));
        if (ModList.get().isLoaded("curios")) {
            MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCapabilities);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new CommonJetpackHandler());
        bus.addListener(ThermalJetpacks::addCreative);
        ModConfig.register();
        RegistryHandler.init();
    }

    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == BuiltInRegistries.f_279662_.m_7745_(new ResourceLocation("thermal", "thermal.tools"))) {
            System.out.println("Adding jetpacks to creative tab");
            ModItemGroup.registerItems(event);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup Method registered.");
        NetworkHandler.registerMessages();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ResourceLocation targetTabId = new ResourceLocation("thermal", "thermal.tools");
        boolean tabExists = BuiltInRegistries.f_279662_.m_7804_(targetTabId);
        if (!tabExists) {
            CREATIVE_TAB.register("tjetpacks.main", ModItemGroup::new);
            CREATIVE_TAB.register(FMLJavaModLoadingContext.get().getModEventBus());
        }
        LOGGER.info("Client Setup Method registered.");
        MinecraftForge.EVENT_BUS.register((Object)new KeybindHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientJetpackHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HUDHandler());
        if (ModList.get().isLoaded("curios")) {
            CuriosIntegration.initRenderers();
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Server starting...");
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("Server stopping...");
        CommonJetpackHandler.clear();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent loggedInEvent) {
        LOGGER.info("{} logging in. Syncing server jetpack configs with client.", (Object)loggedInEvent.getEntity().m_7755_().getString());
        ModConfig.sendServerConfigFiles(loggedInEvent.getEntity());
        LOGGER.info("Finished syncing server jetpack configs.");
    }

    private void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (!ModList.get().isLoaded("curios")) {
            return;
        }
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.m_41720_() instanceof JetpackItem) {
            event.addCapability(CuriosCapability.ID_ITEM, CuriosIntegration.initJetpackCapabilities(stack));
        }
        if (stack.m_41720_() instanceof PilotGogglesItem) {
            event.addCapability(CuriosCapability.ID_ITEM, CuriosIntegration.initGogglesCapabilities(stack));
        }
    }
}

