/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.terrific_trash_cans.common.block_entity;

import com.github.x3r.terrific_trash_cans.common.block.TTCItemHandler;
import com.github.x3r.terrific_trash_cans.common.block_entity.TrashCanBlockEntity;
import com.github.x3r.terrific_trash_cans.common.menu.ItemTrashCanMenu;
import com.github.x3r.terrific_trash_cans.common.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class ItemTrashCanBlockEntity
extends TrashCanBlockEntity {
    private final LazyOptional<TTCItemHandler> itemHandlerOptional = LazyOptional.of(() -> new TTCItemHandler(1));

    public ItemTrashCanBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.ITEM_TRASH_CAN.get(), pPos, pBlockState);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, ItemTrashCanBlockEntity pBlockEntity) {
        ItemStack itemStack = (ItemStack)pBlockEntity.getItems().get(0);
        if (!itemStack.m_41619_()) {
            itemStack.m_41764_(0);
        }
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        if (this.itemHandlerOptional.isPresent()) {
            return ((TTCItemHandler)((Object)this.itemHandlerOptional.orElseThrow(IllegalStateException::new))).getItems();
        }
        return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[0]);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandlerOptional.ifPresent(handler -> handler.deserializeNBT(pTag));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.itemHandlerOptional.ifPresent(handler -> tag.m_128365_("EnergyStorage", (Tag)handler.serializeNBT()));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            return this.itemHandlerOptional.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerOptional.invalidate();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.terrific_trash_cans.item_trash_can");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new ItemTrashCanMenu(i, inventory, this);
    }
}

