/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.terrific_trash_cans.common.block_entity;

import com.github.x3r.terrific_trash_cans.common.block.FluidTrashCanBlock;
import com.github.x3r.terrific_trash_cans.common.block.TTCFluidHandler;
import com.github.x3r.terrific_trash_cans.common.block.TTCItemHandler;
import com.github.x3r.terrific_trash_cans.common.block_entity.TrashCanBlockEntity;
import com.github.x3r.terrific_trash_cans.common.menu.FluidTrashCanMenu;
import com.github.x3r.terrific_trash_cans.common.registry.BlockEntityRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class FluidTrashCanBlockEntity
extends TrashCanBlockEntity {
    private final LazyOptional<TTCFluidHandler> fluidHandlerOptional = LazyOptional.of(() -> new TTCFluidHandler(new TTCFluidHandler.FluidTank[]{new TTCFluidHandler.FluidTank(Integer.MAX_VALUE)}));
    private final LazyOptional<TTCItemHandler> itemHandlerOptional = LazyOptional.of(() -> new TTCItemHandler(1));

    public FluidTrashCanBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.FLUID_TRASH_CAN.get(), pPos, pBlockState);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, FluidTrashCanBlockEntity pBlockEntity) {
        ItemStack stack = (ItemStack)pBlockEntity.getItems().get(0);
        if (!stack.m_41619_()) {
            Optional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
            if (FluidTrashCanBlock.isBucketItem(stack)) {
                pBlockEntity.getItems().set(0, (Object)Items.f_42446_.m_7968_());
            }
            if (FluidTrashCanBlock.isBottleItem(stack)) {
                pBlockEntity.getItems().set(0, (Object)Items.f_42590_.m_7968_());
            }
            if (handler.isPresent()) {
                while (((IFluidHandlerItem)handler.get()).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getAmount() > 0) {
                    ((IFluidHandlerItem)handler.get()).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
        pBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluidHandler -> {
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                if (fluidHandler.getFluidInTank(i).getAmount() <= 0) continue;
                fluidHandler.getFluidInTank(i).setAmount(0);
            }
        });
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        if (this.itemHandlerOptional.isPresent()) {
            return ((TTCItemHandler)((Object)this.itemHandlerOptional.orElseThrow(IllegalStateException::new))).getItems();
        }
        return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[0]);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.fluidHandlerOptional.ifPresent(handler -> handler.deserializeNBT(pTag));
        this.itemHandlerOptional.ifPresent(handler -> handler.deserializeNBT(pTag));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.fluidHandlerOptional.ifPresent(handler -> tag.m_128365_("FluidHandler", (Tag)handler.serializeNBT()));
        this.itemHandlerOptional.ifPresent(handler -> tag.m_128365_("EnergyStorage", (Tag)handler.serializeNBT()));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.FLUID_HANDLER)) {
            return this.fluidHandlerOptional.cast();
        }
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            return this.itemHandlerOptional.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandlerOptional.invalidate();
        this.itemHandlerOptional.invalidate();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.terrific_trash_cans.fluid_trash_can");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new FluidTrashCanMenu(i, inventory, this);
    }
}

