/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.terrific_trash_cans.common.block_entity;

import com.github.x3r.terrific_trash_cans.common.block.TTCEnergyStorage;
import com.github.x3r.terrific_trash_cans.common.block.TTCItemHandler;
import com.github.x3r.terrific_trash_cans.common.block_entity.TrashCanBlockEntity;
import com.github.x3r.terrific_trash_cans.common.menu.EnergyTrashCanMenu;
import com.github.x3r.terrific_trash_cans.common.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class EnergyTrashCanBlockEntity
extends TrashCanBlockEntity {
    private final LazyOptional<TTCEnergyStorage> energyStorageOptional = LazyOptional.of(() -> new TTCEnergyStorage(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE));
    private final LazyOptional<TTCItemHandler> itemHandlerOptional = LazyOptional.of(() -> new TTCItemHandler(1));

    public EnergyTrashCanBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.ENERGY_TRASH_CAN.get(), pPos, pBlockState);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, EnergyTrashCanBlockEntity pBlockEntity) {
        ItemStack itemStack = (ItemStack)pBlockEntity.getItems().get(0);
        if (!itemStack.m_41619_()) {
            itemStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> {
                while (energyStorage.extractEnergy(Integer.MAX_VALUE, true) > 0) {
                    energyStorage.extractEnergy(Integer.MAX_VALUE, false);
                }
            });
        }
        pBlockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> {
            if (energyStorage.getEnergyStored() > 0) {
                energyStorage.extractEnergy(energyStorage.getEnergyStored(), false);
            }
        });
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        if (this.itemHandlerOptional.isPresent()) {
            return ((TTCItemHandler)((Object)this.itemHandlerOptional.orElseThrow(IllegalStateException::new))).getItems();
        }
        return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[0]);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.energyStorageOptional.ifPresent(energyStorage -> energyStorage.deserializeNBT(pTag));
        this.itemHandlerOptional.ifPresent(itemHandler -> itemHandler.deserializeNBT(pTag));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.energyStorageOptional.ifPresent(energyStorage -> tag.m_128365_("EnergyStorage", (Tag)energyStorage.serializeNBT()));
        this.itemHandlerOptional.ifPresent(itemHandler -> tag.m_128365_("ItemHandler", (Tag)itemHandler.serializeNBT()));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ENERGY)) {
            return this.energyStorageOptional.cast();
        }
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            return this.itemHandlerOptional.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyStorageOptional.invalidate();
        this.itemHandlerOptional.invalidate();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.terrific_trash_cans.energy_trash_can");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new EnergyTrashCanMenu(i, inventory, this);
    }
}

