/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.terrific_trash_cans.common.block;

import com.github.x3r.terrific_trash_cans.TerrificTrashCans;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class TTCFluidHandler
implements IFluidHandler,
INBTSerializable<CompoundTag> {
    public static final String TAG_KEY = "FluidHandler";
    private final FluidTank[] tanks;

    public TTCFluidHandler(FluidTank[] tanks) {
        this.tanks = tanks;
    }

    public int getTanks() {
        return this.tanks.length;
    }

    public FluidTank getTank(int tank) {
        FluidTank fluidTank = null;
        try {
            fluidTank = this.tanks[tank];
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            TerrificTrashCans.LOGGER.warn("Attempted to access invalid tank");
        }
        return fluidTank;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getTank(tank).getFluid();
    }

    public void setFluidInTank(int tank, FluidStack stack) {
        this.getTank(tank).setFluid(stack);
    }

    public int getTankCapacity(int tank) {
        return this.getTank(tank).getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.getTank(tank).isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack copy = resource.copy();
        for (int i = 0; i < this.tanks.length; ++i) {
            copy.shrink(this.tanks[i].fill(copy, action));
        }
        return resource.getAmount() - copy.getAmount();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack copy = resource.copy();
        for (int i = this.tanks.length - 1; i >= 0; --i) {
            copy.shrink(this.tanks[i].drain(copy, action).getAmount());
        }
        return new FluidStack(resource.getFluid(), resource.getAmount() - copy.getAmount());
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = 0;
        Fluid fluid = Arrays.stream(this.tanks).map(t -> t.fluid.getFluid()).filter(f -> f != Fluids.f_76191_).toList().get(this.getTanks() - 1);
        for (int i = this.tanks.length - 1; i >= 0; --i) {
            if (!this.tanks[i].getFluid().getFluid().m_6212_(fluid)) continue;
            FluidStack stack = this.tanks[i].drain(maxDrain - drained, action);
            drained += stack.getAmount();
        }
        return new FluidStack(fluid, drained);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.getTanks(); ++i) {
            CompoundTag compoundTag = new CompoundTag();
            this.getFluidInTank(i).writeToNBT(compoundTag);
            compoundTag.m_128405_("Capacity", this.getTankCapacity(i));
            listTag.add((Object)compoundTag);
        }
        nbt.m_128365_("IFluidHandler", (Tag)listTag);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag listTag = nbt.m_128469_(TAG_KEY).m_128437_("IFluidHandler", 10);
        FluidTank[] fluidTanks = (FluidTank[])listTag.stream().map(compoundTag -> {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)compoundTag));
            int capacity = ((CompoundTag)compoundTag).m_128451_("Capacity");
            FluidTank tank = new FluidTank(capacity);
            tank.setFluid(stack);
            return tank;
        }).toArray(FluidTank[]::new);
        for (int i = 0; i < this.getTanks(); ++i) {
            if (this.getTankCapacity(i) != fluidTanks[i].getCapacity()) {
                TerrificTrashCans.LOGGER.warn("Tank capacity was saved incorrectly or changed, still attempting to fill tank");
            }
            this.setFluidInTank(i, fluidTanks[i].getFluid());
        }
    }

    public static class FluidTank
    implements IFluidTank {
        private final int capacity;
        private final Predicate<FluidStack> validator;
        private FluidStack fluid = FluidStack.EMPTY;

        public FluidTank(int capacity) {
            this(capacity, fluidStack -> true);
        }

        public FluidTank(int capacity, Predicate<FluidStack> validator) {
            this.capacity = capacity;
            this.validator = validator;
        }

        @NotNull
        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getFluidAmount() {
            return this.fluid.getAmount();
        }

        public int getCapacity() {
            return this.capacity;
        }

        public boolean isFluidValid(FluidStack stack) {
            return this.validator.test(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || !this.isFluidValid(resource)) {
                return 0;
            }
            if (action.simulate()) {
                if (this.fluid.isEmpty()) {
                    return Math.min(this.capacity, resource.getAmount());
                }
                if (!this.fluid.isFluidEqual(resource)) {
                    return 0;
                }
                return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
            }
            if (this.fluid.isEmpty()) {
                this.fluid = new FluidStack(resource, Math.min(this.capacity, resource.getAmount()));
                this.onContentsChanged();
                return this.fluid.getAmount();
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            int filled = this.capacity - this.fluid.getAmount();
            if (resource.getAmount() < filled) {
                this.fluid.grow(resource.getAmount());
                filled = resource.getAmount();
            } else {
                this.fluid.setAmount(this.capacity);
            }
            if (filled > 0) {
                this.onContentsChanged();
            }
            return filled;
        }

        protected void onContentsChanged() {
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int drained = maxDrain;
            if (this.fluid.getAmount() < drained) {
                drained = this.fluid.getAmount();
            }
            FluidStack stack = new FluidStack(this.fluid, drained);
            if (action.execute() && drained > 0) {
                this.fluid.shrink(drained);
                this.onContentsChanged();
            }
            return stack;
        }

        public void setFluid(FluidStack stack) {
            this.fluid = stack;
        }
    }
}

