/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.terrific_trash_cans.common.block;

import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public class TTCEnergyStorage
implements IEnergyStorage,
INBTSerializable<CompoundTag> {
    public static final String TAG_KEY = "EnergyStorage";
    private int maxReceive;
    private int maxExtract;
    private int maxEnergy;
    private int energy = 0;

    public TTCEnergyStorage(int maxReceive, int maxExtract, int maxEnergy) {
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.maxEnergy = maxEnergy;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int amount = Math.min(Math.min(this.maxReceive, maxReceive), this.getMaxEnergyStored() - this.getEnergyStored());
        if (!simulate) {
            this.energy += amount;
        }
        return amount;
    }

    public int forceReceiveEnergy(int maxReceive, boolean simulate) {
        int amount = Math.min(maxReceive, this.getMaxEnergyStored() - this.getEnergyStored());
        if (!simulate) {
            this.energy += amount;
        }
        return amount;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int amount = Math.min(Math.min(this.maxExtract, maxExtract), this.getEnergyStored());
        if (!simulate) {
            this.energy -= amount;
        }
        return amount;
    }

    public int forceExtractEnergy(int maxExtract, boolean simulate) {
        int amount = Math.min(maxExtract, this.getEnergyStored());
        if (!simulate) {
            this.energy -= amount;
        }
        return amount;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public void setEnergyStored(int energy) {
        this.energy = Math.min(this.getMaxEnergyStored(), energy);
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("MaxReceive", this.maxReceive);
        tag.m_128405_("MaxExtract", this.maxExtract);
        tag.m_128405_("MaxEnergy", this.maxEnergy);
        tag.m_128405_("Energy", this.energy);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag tag = nbt.m_128469_(TAG_KEY);
        this.maxReceive = tag.m_128451_("MaxReceive");
        this.maxExtract = tag.m_128451_("MaxExtract");
        this.maxEnergy = tag.m_128451_("MaxEnergy");
        this.energy = tag.m_128451_("Energy");
    }
}

