/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.terrific_trash_cans.common.block;

import com.github.x3r.terrific_trash_cans.common.block.TrashCanBlock;
import com.github.x3r.terrific_trash_cans.common.block_entity.FluidTrashCanBlockEntity;
import com.github.x3r.terrific_trash_cans.common.registry.BlockEntityRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class FluidTrashCanBlock
extends TrashCanBlock {
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof FluidTrashCanBlockEntity) {
            ItemStack stack = pPlayer.m_21120_(pHand);
            Optional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
            if (!pPlayer.m_6047_()) {
                if (FluidTrashCanBlock.isBucketItem(stack)) {
                    pPlayer.m_21008_(pHand, Items.f_42446_.m_7968_());
                    return InteractionResult.CONSUME;
                }
                if (FluidTrashCanBlock.isBottleItem(stack)) {
                    pPlayer.m_21008_(pHand, Items.f_42590_.m_7968_());
                    return InteractionResult.CONSUME;
                }
                if (handler.isPresent()) {
                    while (((IFluidHandlerItem)handler.get()).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getAmount() > 0) {
                        ((IFluidHandlerItem)handler.get()).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                    }
                    return InteractionResult.CONSUME;
                }
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)((MenuProvider)blockentity), buf -> buf.m_130064_(pPos));
        }
        return InteractionResult.CONSUME;
    }

    public static boolean isBucketItem(ItemStack stack) {
        return stack.m_41720_() instanceof BucketItem || stack.m_41720_() instanceof SolidBucketItem || stack.m_41720_() instanceof MilkBucketItem;
    }

    public static boolean isBottleItem(ItemStack stack) {
        return stack.m_41720_() instanceof PotionItem || stack.m_41720_() instanceof HoneyBottleItem || stack.m_41720_() instanceof ExperienceBottleItem;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.m_5776_() ? null : FluidTrashCanBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.FLUID_TRASH_CAN.get()), FluidTrashCanBlockEntity::serverTick);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new FluidTrashCanBlockEntity(blockPos, blockState);
    }
}

