/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.squatgrow;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.wuffs.squatgrow.actions.Actions;
import dev.wuffs.squatgrow.config.ComputedRequirements;
import dev.wuffs.squatgrow.config.SquatGrowConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.YamlConfigSerializer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SquatGrow {
    public static final String MOD_ID = "squatgrow";
    private static final Logger LOGGER = LoggerFactory.getLogger(SquatGrow.class);
    public static SquatGrowConfig config;
    public static ConfigHolder<SquatGrowConfig> configHolder;
    public static final Set<TagKey<Block>> tagCache;
    public static final Set<String> wildcardCache;
    public static ComputedRequirements computedRequirements;
    public static Enchantment computedEnchantment;

    public static void init() {
        configHolder = AutoConfig.register(SquatGrowConfig.class, YamlConfigSerializer::new);
        configHolder.registerLoadListener(SquatGrow::onConfigChanged);
        configHolder.registerSaveListener(SquatGrow::onConfigChanged);
        configHolder.load();
        config = (SquatGrowConfig)configHolder.get();
        LifecycleEvent.SETUP.register(SquatGrow::onSetup);
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new ReloadHandler());
    }

    private static void onSetup() {
        LOGGER.debug("Starting setup");
        Actions.get().setup();
    }

    private static InteractionResult onConfigChanged(ConfigHolder<SquatGrowConfig> holder, SquatGrowConfig newConfig) {
        tagCache.clear();
        wildcardCache.clear();
        tagCache.addAll(newConfig.ignoreList.stream().filter(e -> e.contains("#")).map(e -> TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(e.replace("#", "")))).collect(Collectors.toSet()));
        wildcardCache.addAll(newConfig.ignoreList.stream().filter(e -> e.contains("*")).map(e -> e.split(":")[0]).collect(Collectors.toSet()));
        List<String> heldItemRequirement = newConfig.requirements.heldItemRequirement;
        Map<EquipmentSlot, String> equipmentRequirement = newConfig.requirements.equipmentRequirement;
        Pair<List<ItemStack>, List<TagKey<Item>>> computedHeldEntries = SquatGrow.computeItemsAndTagsFromStringList(heldItemRequirement);
        Map<EquipmentSlot, ItemStack> equipmentRequirementStacks = equipmentRequirement.entrySet().stream().filter(e -> !((String)e.getValue()).contains("#")).collect(Collectors.toMap(Map.Entry::getKey, e -> new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation((String)e.getValue())))));
        Map<EquipmentSlot, TagKey<Item>> equipmentRequirementTags = equipmentRequirement.entrySet().stream().filter(e -> ((String)e.getValue()).contains("#")).collect(Collectors.toMap(Map.Entry::getKey, e -> TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(((String)e.getValue()).replace("#", "")))));
        computedRequirements = new ComputedRequirements((List)computedHeldEntries.getLeft(), (List)computedHeldEntries.getRight(), equipmentRequirementStacks, equipmentRequirementTags);
        if (!newConfig.requirements.requiredEnchantment.isEmpty()) {
            ResourceLocation enchantmentRl = new ResourceLocation(newConfig.requirements.requiredEnchantment);
            Enchantment enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(enchantmentRl);
            if (enchantment != Enchantments.f_44987_ || enchantmentRl.equals((Object)new ResourceLocation("minecraft:fortune"))) {
                computedEnchantment = enchantment;
            }
        } else {
            computedEnchantment = null;
        }
        return InteractionResult.SUCCESS;
    }

    public static Boolean allowTwerk(BlockState state) {
        return SquatGrow.config.useWhitelist == SquatGrow.isBlockInIgnoreList(state);
    }

    private static boolean isBlockInIgnoreList(BlockState state) {
        ResourceLocation resourceLocation = state.m_60734_().arch$registryName();
        if (resourceLocation == null) {
            return false;
        }
        if (SquatGrow.config.ignoreList.contains(resourceLocation.toString()) || wildcardCache.contains(resourceLocation.m_135827_())) {
            return true;
        }
        return tagCache.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0));
    }

    private static Pair<List<ItemStack>, List<TagKey<Item>>> computeItemsAndTagsFromStringList(List<String> list) {
        List<ItemStack> stacks = list.stream().filter(e -> !e.contains("#")).map(e -> new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(e)))).toList();
        List<TagKey> tags = list.stream().filter(e -> e.contains("#")).map(e -> TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(e.replace("#", "")))).toList();
        return Pair.of(stacks, tags);
    }

    static {
        tagCache = new HashSet<TagKey<Block>>();
        wildcardCache = new HashSet<String>();
        computedRequirements = null;
        computedEnchantment = null;
    }

    static class ReloadHandler
    implements ResourceManagerReloadListener {
        ReloadHandler() {
        }

        public void m_6213_(ResourceManager manager) {
            configHolder.load();
            config = (SquatGrowConfig)configHolder.get();
        }
    }
}

