/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;

public record StorageOpennessMessage(BlockPos pos, boolean shouldBeOpen) {
    public static void encode(StorageOpennessMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130064_(msg.pos);
        packetBuffer.writeBoolean(msg.shouldBeOpen);
    }

    public static StorageOpennessMessage decode(FriendlyByteBuf packetBuffer) {
        return new StorageOpennessMessage(packetBuffer.m_130135_(), packetBuffer.readBoolean());
    }

    static void onMessage(StorageOpennessMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> StorageOpennessMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(StorageOpennessMessage msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        WorldHelper.getLoadedBlockEntity((Level)player.m_9236_(), (BlockPos)msg.pos, StorageBlockEntity.class).ifPresent(storageBlockEntity -> storageBlockEntity.setShouldBeOpen(msg.shouldBeOpen));
    }
}

