/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.p3pp3rf1y.sophisticatedcore.client.render.BlockHighlightRenderHelper;
import net.p3pp3rf1y.sophisticatedcore.client.render.IClientHighlightHandler;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.RequestItemHighlightsMessage;
import net.p3pp3rf1y.sophisticatedcore.util.Easing;
import net.p3pp3rf1y.sophisticatedcore.util.IDoubleBlock;
import net.p3pp3rf1y.sophisticatedcore.util.VoxelOutliner;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class ItemInStorageHighlightRenderer {
    public static final int HIGHLIGHT_DURATION = 40;
    public static final int HIGHLIGHT_RANGE = 32;
    public static final int MATCHING_STACK_HIGHLIGHT_COLOR = 5025616;
    public static final int MATCHING_ITEM_HIGHLIGHT_COLOR = 4367861;
    private static List<BlockPos> highlightedStackPositions = Collections.emptyList();
    private static List<BlockPos> highlightedItemPositions = Collections.emptyList();
    private static List<BlockPos> highlightedEmptyTargetPositions = Collections.emptyList();
    private static long highlightExpireTime = 0L;
    @Nullable
    private static List<HighlightedBlock> cachedMatchingStackHighlights = null;
    @Nullable
    private static List<HighlightedBlock> cachedMatchingItemHighlights = null;
    @Nullable
    private static List<HighlightedBlock> cachedEmptyTargetHighlights = null;
    private static List<IClientHighlightHandler<?>> highlightHandlers = new ArrayList();

    public static void registerHighlightHandler(IClientHighlightHandler<?> highlightHandler) {
        highlightHandlers.add(highlightHandler);
    }

    public static void highlightItem(LocalPlayer player, ItemStack stack) {
        List<BlockPos> positions = WorldHelper.getBlockEntitiesInRange(player.m_9236_(), player.m_20183_(), 32, IControllableStorage.class).stream().map(IControllerBoundable::getStorageBlockPos).toList();
        LinkedHashMap<ResourceLocation, Object> extras = new LinkedHashMap<ResourceLocation, Object>();
        highlightHandlers.forEach(h -> extras.put(h.getPayloadHandlerId(), h.buildClientRequestData(player, stack)));
        if (!positions.isEmpty() || !extras.isEmpty()) {
            PacketHandler.INSTANCE.sendToServer(new RequestItemHighlightsMessage(stack, positions, extras));
        }
    }

    public static void setHighlightedPositions(List<BlockPos> stackPositions, List<BlockPos> itemPositions, List<BlockPos> emptyTargetPositions) {
        highlightedStackPositions = stackPositions;
        highlightedItemPositions = itemPositions;
        highlightedEmptyTargetPositions = emptyTargetPositions;
        highlightExpireTime = Minecraft.m_91087_().f_91073_.m_46467_() + 40L;
        cachedMatchingStackHighlights = null;
        cachedMatchingItemHighlights = null;
        cachedEmptyTargetHighlights = null;
    }

    public static void render(PoseStack poseStack, float partialTick, Vec3 cameraPos) {
        Minecraft mc = Minecraft.m_91087_();
        if (highlightExpireTime < mc.f_91073_.m_46467_()) {
            if (!(highlightedStackPositions.isEmpty() && highlightedItemPositions.isEmpty() && highlightedEmptyTargetPositions.isEmpty())) {
                highlightedStackPositions = Collections.emptyList();
                highlightedItemPositions = Collections.emptyList();
                highlightedEmptyTargetPositions = Collections.emptyList();
                cachedMatchingStackHighlights = null;
                cachedMatchingItemHighlights = null;
                cachedEmptyTargetHighlights = null;
                highlightHandlers.forEach(IClientHighlightHandler::clearCache);
            }
            return;
        }
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        if (cachedMatchingStackHighlights == null) {
            cachedMatchingStackHighlights = highlightedStackPositions.stream().map(pos -> ItemInStorageHighlightRenderer.getHighlightedBlock(mc, pos)).toList();
        }
        if (cachedMatchingItemHighlights == null) {
            cachedMatchingItemHighlights = highlightedItemPositions.stream().map(pos -> ItemInStorageHighlightRenderer.getHighlightedBlock(mc, pos)).toList();
        }
        if (cachedEmptyTargetHighlights == null) {
            cachedEmptyTargetHighlights = highlightedEmptyTargetPositions.stream().map(pos -> ItemInStorageHighlightRenderer.getHighlightedBlock(mc, pos)).toList();
        }
        cachedMatchingStackHighlights.forEach(bh -> ItemInStorageHighlightRenderer.renderHighlightedBlock(poseStack, partialTick, cameraPos, bh, mc, buffer, 5025616));
        cachedMatchingItemHighlights.forEach(bh -> ItemInStorageHighlightRenderer.renderHighlightedBlock(poseStack, partialTick, cameraPos, bh, mc, buffer, 4367861));
        cachedEmptyTargetHighlights.forEach(bh -> ItemInStorageHighlightRenderer.renderHighlightedBlock(poseStack, partialTick, cameraPos, bh, mc, buffer, 16771899));
        highlightHandlers.forEach(callback -> callback.render(poseStack, partialTick, cameraPos));
    }

    private static void renderHighlightedBlock(PoseStack poseStack, float partialTick, Vec3 cameraPos, HighlightedBlock bh, Minecraft mc, MultiBufferSource.BufferSource buffer, int color) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)bh.pos.m_123341_() - cameraPos.m_7096_(), (double)bh.pos.m_123342_() - cameraPos.m_7098_(), (double)bh.pos.m_123343_() - cameraPos.m_7094_());
        poseStack.m_85837_(bh.pivot.f_82479_, bh.pivot.f_82480_, bh.pivot.f_82481_);
        float scale = 1.0f + Easing.EASE_IN_OUT_CUBIC.ease((float)ItemInStorageHighlightRenderer.tri01(mc.f_91073_.m_46467_(), 15.0, partialTick)) * 0.05f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85837_(-bh.pivot.f_82479_, -bh.pivot.f_82480_, -bh.pivot.f_82481_);
        BlockHighlightRenderHelper.renderThickEdges(poseStack, (MultiBufferSource)buffer, color, bh.edges(), bh.pos().m_123341_(), bh.pos().m_123342_(), bh.pos().m_123343_());
        poseStack.m_85849_();
    }

    private static HighlightedBlock getHighlightedBlock(Minecraft mc, BlockPos pos) {
        ClientLevel level = mc.f_91073_;
        BlockState state = level.m_8055_(pos);
        VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
        Block block = state.m_60734_();
        if (block instanceof IDoubleBlock) {
            IDoubleBlock doubleBlock = (IDoubleBlock)block;
            VoxelShape finalShape = shape;
            shape = doubleBlock.getOtherPosition(state, pos).map(otherPos -> {
                BlockState otherState = level.m_8055_(otherPos);
                VoxelShape otherShape = otherState.m_60808_((BlockGetter)level, otherPos);
                otherShape = otherShape.m_83216_((double)(otherPos.m_123341_() - pos.m_123341_()), (double)(otherPos.m_123342_() - pos.m_123342_()), (double)(otherPos.m_123343_() - pos.m_123343_()));
                return Shapes.m_83113_((VoxelShape)finalShape, (VoxelShape)otherShape, (BooleanOp)BooleanOp.f_82695_);
            }).orElse(shape);
        }
        return new HighlightedBlock(pos, VoxelOutliner.linesFromVoxelShapeSimplified(shape, pos), shape.m_83215_().m_82399_());
    }

    public static double tri01(double ticks, double periodTicks, double phaseOffsetTicks) {
        if (periodTicks <= 0.0) {
            return 0.0;
        }
        double phase = (ticks + phaseOffsetTicks) % periodTicks / (periodTicks - 1.0);
        return 1.0 - Math.abs(2.0 * phase - 1.0);
    }

    private record HighlightedBlock(BlockPos pos, List<VoxelOutliner.Edge> edges, Vec3 pivot) {
    }
}

