/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.java;

import com.probejs.ProbeJS;
import com.probejs.docs.formatter.ClassResolver;
import com.probejs.docs.formatter.NameResolver;
import com.probejs.jdoc.java.ConstructorInfo;
import com.probejs.jdoc.java.FieldInfo;
import com.probejs.jdoc.java.MethodInfo;
import com.probejs.jdoc.java.type.ITypeInfo;
import com.probejs.jdoc.java.type.InfoTypeResolver;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassInfo {
    public static final Map<Class<?>, ClassInfo> CLASS_CACHE = new HashMap();
    public static final Map<String, ClassInfo> CLASS_NAME_CACHE = new HashMap<String, ClassInfo>();
    private static int classCount = 0;
    private final Class<?> clazzRaw;
    private final String name;
    private final int modifiers;
    private final boolean isInterface;
    private final List<ITypeInfo> parameters;
    private List<MethodInfo> methodInfo;
    private List<FieldInfo> fieldInfo;
    private List<ConstructorInfo> constructorInfo;
    private final ClassInfo superClass;
    private final List<ClassInfo> interfaces;
    private final List<Annotation> annotations;

    public static ClassInfo getOrCache(Class<?> clazz) {
        if (CLASS_CACHE.containsKey(clazz)) {
            return CLASS_CACHE.get(clazz);
        }
        if (++classCount > 0 && classCount % 10000 == 0) {
            ProbeJS.LOGGER.info("%s classes loaded".formatted(classCount));
        }
        ClassInfo info = ClassResolver.acceptClass(clazz.getName()) ? new ClassInfo(clazz) : new ClassInfo(Object.class);
        CLASS_CACHE.put(clazz, info);
        CLASS_NAME_CACHE.put(info.getName(), info);
        return info;
    }

    private ClassInfo(Class<?> clazz) {
        this.clazzRaw = clazz;
        this.name = MethodInfo.getRemappedOrOriginalClass(this.clazzRaw);
        this.modifiers = this.clazzRaw.getModifiers();
        this.isInterface = this.clazzRaw.isInterface();
        this.superClass = this.clazzRaw.getSuperclass() == Object.class || this.clazzRaw.getSuperclass() == null ? null : ClassInfo.getOrCache(this.clazzRaw.getSuperclass());
        this.interfaces = Arrays.stream(this.clazzRaw.getInterfaces()).map(ClassInfo::getOrCache).collect(Collectors.toList());
        this.parameters = Arrays.stream(this.clazzRaw.getTypeParameters()).map(InfoTypeResolver::resolveType).collect(Collectors.toList());
        this.annotations = new ArrayList<Annotation>();
        this.annotations.addAll(List.of(clazz.getAnnotations()));
        if (clazz.isAnnotationPresent(HideFromJS.class)) {
            this.methodInfo = List.of();
            this.fieldInfo = List.of();
            this.constructorInfo = List.of();
            return;
        }
        try {
            ScriptManager manager = ServerScriptManager.getScriptManager();
            JavaMembers members = JavaMembers.lookupClass((Context)manager.context, (Scriptable)manager.topLevelScope, clazz, clazz, (boolean)false);
            this.constructorInfo = members.getAccessibleConstructors().stream().map(ConstructorInfo::new).collect(Collectors.toList());
            this.methodInfo = members.getAccessibleMethods(manager.context, false).stream().map(m -> new MethodInfo((JavaMembers.MethodInfo)m, clazz)).collect(Collectors.toList());
            HashSet<String> occurred = new HashSet<String>();
            HashSet<String> duplicated = new HashSet<String>();
            for (MethodInfo info2 : this.methodInfo) {
                String key = this.getOccurrenceKey(info2);
                if (!occurred.contains(key)) {
                    occurred.add(key);
                    continue;
                }
                duplicated.add(key);
            }
            Set needsExplicit = this.methodInfo.stream().filter(info -> duplicated.contains(this.getOccurrenceKey((MethodInfo)info))).collect(Collectors.toSet());
            for (MethodInfo info3 : needsExplicit) {
                MethodInfo explicit = new MethodInfo(info3.getMethod(), info3.getName(), clazz);
                explicit.setName(explicit.getExplicitName());
                this.methodInfo.add(explicit);
            }
            this.fieldInfo = members.getAccessibleFields(manager.context, false).stream().filter(f -> f.field.getDeclaringClass() == clazz).map(FieldInfo::new).collect(Collectors.toList());
        }
        catch (Throwable e) {
            e.printStackTrace();
            ProbeJS.LOGGER.warn("Error occurred when resolving class %s! Touching the class with KubeJS will likely to crash too!".formatted(clazz.getName()));
            this.constructorInfo = List.of();
            this.methodInfo = List.of();
            this.fieldInfo = List.of();
            NameResolver.putResolvedName(clazz.getName(), new NameResolver.ResolvedName(List.of("probejs", "internal", "NotResolved")));
        }
    }

    private String getOccurrenceKey(MethodInfo info) {
        return "%s(%s)".formatted(info.getName(), info.getParams().size());
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public ClassInfo getSuperClass() {
        return this.superClass;
    }

    public List<ClassInfo> getInterfaces() {
        return this.interfaces;
    }

    public List<FieldInfo> getFieldInfo() {
        return this.fieldInfo;
    }

    public List<ConstructorInfo> getConstructorInfo() {
        return this.constructorInfo;
    }

    public List<MethodInfo> getMethodInfo() {
        return this.methodInfo;
    }

    public List<ITypeInfo> getParameters() {
        return this.parameters;
    }

    public boolean isEnum() {
        return this.clazzRaw.isEnum();
    }

    public Class<?> getClazzRaw() {
        return this.clazzRaw;
    }

    public String getName() {
        return this.name;
    }

    public ITypeInfo getSuperClassType() {
        return InfoTypeResolver.resolveType(this.clazzRaw.getGenericSuperclass());
    }

    public List<ITypeInfo> getInterfaceTypes() {
        return Arrays.stream(this.clazzRaw.getGenericInterfaces()).map(InfoTypeResolver::resolveType).collect(Collectors.toList());
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    private static boolean hasIdenticalParentMethod(Method method, Class<?> clazz) {
        if (method.isDefault()) {
            return false;
        }
        Class<?> parent = clazz.getSuperclass();
        if (parent == null) {
            return false;
        }
        while (parent != null) {
            try {
                Method parentMethod = parent.getMethod(method.getName(), method.getParameterTypes());
                return parentMethod.getGenericReturnType().equals(method.getGenericReturnType());
            }
            catch (NoSuchMethodException e) {
                parent = parent.getSuperclass();
            }
        }
        return false;
    }
}

