/*
 * Decompiled with CFR 0.152.
 */
package novamachina.novacore.world.level.material;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import novamachina.novacore.world.item.ItemDefinition;
import novamachina.novacore.world.level.block.BlockDefinition;

public class FluidDefinition<F extends FlowingFluid, B extends BlockDefinition<? extends LiquidBlock>, I extends ItemDefinition<? extends Item>> {
    private final ResourceLocation id;
    private final String englishName;
    private final F stillFluid;
    private final F flowingFluid;
    private final FluidType fluidType;
    private final Supplier<B> block;
    private final Supplier<I> bucket;

    public FluidDefinition(String englishName, ResourceLocation id, Supplier<F> stillFluid, Supplier<F> flowingFluid, Supplier<B> block, Supplier<I> bucket) {
        Objects.requireNonNull(id, "id");
        this.id = id;
        this.englishName = englishName;
        this.stillFluid = (FlowingFluid)stillFluid.get();
        this.flowingFluid = (FlowingFluid)flowingFluid.get();
        this.block = block;
        this.bucket = bucket;
        this.fluidType = this.createFluidType();
    }

    private FluidType createFluidType() {
        return new FluidType(FluidType.Properties.create()){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return FluidDefinition.this.getTexture();
                    }

                    public ResourceLocation getFlowingTexture() {
                        return FluidDefinition.this.getFlowTexture();
                    }
                });
            }
        };
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ResourceLocation getFlowingId() {
        return new ResourceLocation(this.id.m_135827_(), String.format("%s_flow", this.id.m_135815_()));
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation(this.id.m_135827_(), String.format("block/%s", this.id.m_135815_()));
    }

    public ResourceLocation getFlowTexture() {
        return new ResourceLocation(this.id.m_135827_(), String.format("block/%s_flow", this.id.m_135815_()));
    }

    public B getBlock() {
        return (B)((BlockDefinition)this.block.get());
    }

    public I getBucket() {
        return (I)((ItemDefinition)this.bucket.get());
    }

    public FlowingFluid getFlowingFluid() {
        return this.flowingFluid;
    }

    public FlowingFluid getStillFluid() {
        return this.stillFluid;
    }

    public FluidType getFluidType() {
        return this.fluidType;
    }
}

