/*
 * Decompiled with CFR 0.152.
 */
package novamachina.novacore.core.registries;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import novamachina.novacore.core.registries.AbstractRegistry;
import novamachina.novacore.world.level.block.BlockDefinition;
import novamachina.novacore.world.level.block.BlockEntityTypeDefinition;

public class BlockEntityTypeRegistry
extends AbstractRegistry<BlockEntityTypeDefinition<? extends BlockEntity>> {
    public BlockEntityTypeRegistry(String modId) {
        super(modId);
    }

    @SafeVarargs
    public final <T extends BlockEntity> BlockEntityTypeDefinition<T> create(String shortId, BlockEntityFactory<T> factory, BlockDefinition<? extends Block> ... blockDefinitions) {
        Preconditions.checkArgument((blockDefinitions.length > 0 ? 1 : 0) != 0);
        ResourceLocation id = this.id(shortId);
        Block[] blocks = (Block[])Arrays.stream(blockDefinitions).map(BlockDefinition::block).toArray(Block[]::new);
        AtomicReference<BlockEntityType> typeHolder = new AtomicReference<BlockEntityType>();
        BlockEntityType.BlockEntitySupplier supplier = (blockPos, blockState) -> factory.create((BlockEntityType)typeHolder.get(), blockPos, blockState);
        BlockEntityType type = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)supplier, (Block[])blocks).m_58966_(null);
        typeHolder.set(type);
        BlockEntityTypeDefinition definition = new BlockEntityTypeDefinition(id, type);
        this.register(definition);
        return definition;
    }

    @FunctionalInterface
    public static interface BlockEntityFactory<T extends BlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

