/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock.dynamic.utils;

import dev.ftb.mods.ftbquests.quest.IslandData;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.team.TeamData;
import dev.ftb.mods.ftbquests.quest.team.TeamManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;

public class QuestTeamBridge {
    private static final QuestTeamBridge INSTANCE = new QuestTeamBridge();

    private QuestTeamBridge() {
    }

    public static QuestTeamBridge getInstance() {
        return INSTANCE;
    }

    public void syncTeamData(UUID ownerUuid, Collection<UUID> memberUuids) {
        IslandData islandData;
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file == null || file.server == null) {
            return;
        }
        MinecraftServer server = file.server;
        TeamManager teamManager = TeamManager.getInstance((MinecraftServer)server);
        TeamData teamData = teamManager.getTeam(ownerUuid);
        if (teamData == null) {
            teamData = teamManager.createTeam("Island of " + ownerUuid.toString().substring(0, 8), ownerUuid);
        }
        if (teamData != null) {
            HashSet<UUID> apiMembers = new HashSet<UUID>(memberUuids);
            HashSet currentMembers = new HashSet(teamData.getMembers().keySet());
            for (UUID apiMember : apiMembers) {
                if (currentMembers.contains(apiMember)) continue;
                teamManager.addPlayerToTeam(apiMember, teamData);
            }
            for (UUID currentMember : currentMembers) {
                if (apiMembers.contains(currentMember) || currentMember.equals(ownerUuid)) continue;
                teamManager.removePlayerFromTeam(currentMember);
            }
        }
        if ((islandData = file.getOrCreateIslandData(ownerUuid)) != null) {
            islandData.setMembers(memberUuids);
            islandData.markDirty();
        }
    }

    public boolean isPlayerOnTeam(UUID playerUuid, UUID islandOwnerUuid) {
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file == null || file.server == null) {
            return false;
        }
        TeamManager teamManager = TeamManager.getInstance((MinecraftServer)file.server);
        TeamData teamData = teamManager.getTeam(islandOwnerUuid);
        return teamData != null && teamData.isMember(playerUuid);
    }
}

