/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock.dynamic.events;

import com.mojang.logging.LogUtils;
import com.skyblock.dynamic.SkyBlockMod;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class PlayerEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> freezeTask;

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.freezeTask != null && !this.freezeTask.isDone()) {
            this.freezeTask.cancel(false);
            LOGGER.info("Player logged in. Canceled scheduled island freeze.");
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (server != null && server.m_7416_() - 1 == 0 && SkyBlockMod.isIslandServer()) {
            LOGGER.info("Last player logged out. Scheduling island freeze in 10 minutes.");
            this.scheduleFreezeTask(SkyBlockMod.getCreatorUuid());
        }
    }

    private void scheduleFreezeTask(String creatorUuidStr) {
        if (creatorUuidStr == null) {
            LOGGER.error("Cannot schedule freeze task: creator UUID is null.");
            return;
        }
        Runnable task = () -> LOGGER.info("Island freeze task was triggered for creator {} but is currently disabled.", (Object)creatorUuidStr);
        this.freezeTask = this.scheduler.schedule(task, 10L, TimeUnit.MINUTES);
    }
}

