/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock.dynamic;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.mojang.logging.LogUtils;
import com.skyblock.dynamic.Config;
import com.skyblock.dynamic.events.PlayerEventHandler;
import com.skyblock.dynamic.nestworld.mods.NestworldModsServer;
import com.skyblock.dynamic.utils.IslandContext;
import java.net.http.HttpClient;
import java.nio.file.Path;
import java.time.Duration;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="skyblock")
public class SkyBlockMod {
    public static final String MODID = "skyblock";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(10L)).build();
    private static IslandContext islandContext = IslandContext.getDefault();

    public SkyBlockMod(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        modEventBus.addListener(this::onModConfigEvent);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC, "skyblock-common.toml");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("SkyBlockMod: Common Setup Initialized.");
    }

    public void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == Config.SPEC) {
            Config.bake();
            LOGGER.info("SkyBlockMod: Common configuration reloaded from skyblock-common.toml.");
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
    }

    @SubscribeEvent
    public void onServerAboutToStart(ServerAboutToStartEvent event) {
        Path serverBasePath = event.getServer().m_6237_().toPath();
        this.loadIslandContextData(serverBasePath);
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        if (islandContext.isIslandServer()) {
            LOGGER.info("SkyBlockMod: Server started. Running as an ISLAND SERVER. Creator UUID: {}", (Object)islandContext.getCreatorUuid());
            this.sendIslandReadyForPlayersSignal();
        } else {
            LOGGER.info("SkyBlockMod: Server started. Running as a HUB SERVER.");
        }
    }

    private void sendIslandReadyForPlayersSignal() {
        LOGGER.info("Island ready signal was triggered but is currently disabled.");
    }

    private void loadIslandContextData(Path serverBasePath) {
        Path islandDataPath = serverBasePath.resolve("world").resolve("serverconfig").resolve("skyblock_island_data.toml");
        LOGGER.info("SkyBlockMod: Attempting to load island context from: {}", (Object)islandDataPath.toString());
        if (!islandDataPath.toFile().exists()) {
            LOGGER.warn("SkyBlockMod: skyblock_island_data.toml not found at {}. Using default context (not an island server).", (Object)islandDataPath);
            islandContext = IslandContext.getDefault();
            return;
        }
        try (CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)islandDataPath).sync().autosave().writingMode(WritingMode.REPLACE).build();){
            config.load();
            boolean isIsland = config.getOptional("is_island_server").map(obj -> Boolean.valueOf(String.valueOf(obj))).orElse(false);
            String creatorUuid = config.getOptional("creator_uuid").map(String::valueOf).orElse(null);
            if (isIsland && (creatorUuid == null || creatorUuid.trim().isEmpty())) {
                LOGGER.error("SkyBlockMod: skyblock_island_data.toml indicates this is an island server, but 'creator_uuid' is missing or empty. Treating as HUB.");
                islandContext = IslandContext.getDefault();
            } else if (isIsland) {
                try {
                    UUID.fromString(creatorUuid.trim());
                    islandContext = new IslandContext(true, creatorUuid.trim());
                    LOGGER.info("SkyBlockMod: Successfully loaded island context: isIslandServer={}, creatorUuid={}", (Object)isIsland, (Object)creatorUuid);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("SkyBlockMod: 'creator_uuid' in skyblock_island_data.toml is not a valid UUID: {}. Treating as HUB. Error: {}", (Object)creatorUuid, (Object)e.getMessage());
                    islandContext = IslandContext.getDefault();
                }
            } else {
                islandContext = new IslandContext(false, creatorUuid != null ? creatorUuid.trim() : null);
                LOGGER.info("SkyBlockMod: Successfully loaded island context: isIslandServer=false. creator_uuid (if any) will be ignored for hub logic.");
            }
        }
        catch (Exception e) {
            LOGGER.error("SkyBlockMod: Failed to load or parse skyblock_island_data.toml. Using default context. Error: {}", (Object)e.getMessage(), (Object)e);
            islandContext = IslandContext.getDefault();
        }
    }

    public static boolean isIslandServer() {
        return islandContext.isIslandServer();
    }

    public static String getCreatorUuid() {
        return islandContext.getCreatorUuid();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        LOGGER.info("Player {} logged in, triggering island data refresh.", (Object)player.m_7755_().getString());
        NestworldModsServer.ISLAND_PROVIDER.refreshAndGetTeamId(player.m_20148_());
    }

    @Mod.EventBusSubscriber(modid="skyblock", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("SkyBlockMod: Client Setup");
        }
    }
}

