/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock.dynamic;

import java.util.regex.Pattern;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.StringUtils;

@Mod.EventBusSubscriber(modid="skyblock", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final Pattern URL_PATTERN = Pattern.compile("^https?://[a-zA-Z0-9.-]+(:[0-9]{1,5})?(/.*)?$");
    private static final ForgeConfigSpec.ConfigValue<String> API_BASE_URL = BUILDER.comment("The base URL for the SkyBlock API (e.g., http://localhost:8000/api/v1)").define("apiBaseUrl", (Object)"http://localhost:8000/api/v1", Config::validateUrl);
    private static final ForgeConfigSpec.IntValue API_REQUEST_TIMEOUT_SECONDS = BUILDER.comment("Timeout in seconds for API requests to the SkyBlock API.").defineInRange("apiRequestTimeoutSeconds", 10, 5, 60);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    private static String apiBaseUrl;
    private static int apiRequestTimeoutSeconds;

    private static boolean validateUrl(Object obj) {
        if (obj instanceof String) {
            String urlString = (String)obj;
            return !StringUtils.isBlank((CharSequence)urlString) && URL_PATTERN.matcher(urlString).matches();
        }
        return false;
    }

    public static String getApiBaseUrl() {
        if (apiBaseUrl == null) {
            apiBaseUrl = (String)API_BASE_URL.get();
        }
        return apiBaseUrl;
    }

    public static int getApiRequestTimeoutSeconds() {
        return apiRequestTimeoutSeconds > 0 ? apiRequestTimeoutSeconds : 10;
    }

    public static void bake() {
        apiBaseUrl = (String)API_BASE_URL.get();
        apiRequestTimeoutSeconds = (Integer)API_REQUEST_TIMEOUT_SECONDS.get();
        if (apiBaseUrl != null && !apiBaseUrl.endsWith("/")) {
            apiBaseUrl = apiBaseUrl + "/";
        }
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.bake();
        }
    }

    @SubscribeEvent
    static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.bake();
        }
    }
}

