/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CompiledDropperModule
extends CompiledModule {
    private final int pickupDelay = this.getAugmentCount((Item)ModItems.PICKUP_DELAY_AUGMENT.get()) * 10;

    public CompiledDropperModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        ItemStack stack = router.getBufferItemStack();
        if (this.getFilter().test(stack) && this.isRegulationOK(router, false)) {
            int nItems = Math.min(this.getItemsPerTick(router), stack.m_41613_() - this.getRegulationAmount());
            if (nItems <= 0) {
                return false;
            }
            ItemStack toDrop = router.peekBuffer(nItems);
            BlockPos pos = this.getTarget().gPos.m_122646_();
            Direction face = this.getTarget().face;
            ItemEntity item = new ItemEntity(router.nonNullLevel(), (double)pos.m_123341_() + 0.5 + 0.2 * (double)face.m_122429_(), (double)pos.m_123342_() + 0.5 + 0.2 * (double)face.m_122430_(), (double)pos.m_123343_() + 0.5 + 0.2 * (double)face.m_122431_(), toDrop);
            item.m_32010_(this.pickupDelay);
            this.setupItemVelocity(router, item);
            router.nonNullLevel().m_7967_((Entity)item);
            router.extractBuffer(toDrop.m_41613_());
            return true;
        }
        return false;
    }

    void setupItemVelocity(ModularRouterBlockEntity router, ItemEntity item) {
        item.m_20334_(0.0, 0.0, 0.0);
    }
}

