/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.modularrouters.block.ModularRouterBlock;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.render.ModRenderTypes;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.util.BeamData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ModularRouterBER
implements BlockEntityRenderer<ModularRouterBlockEntity> {
    private static final Vector3f ROTATION = new Vector3f(0.15f, 1.0f, 0.0f);
    private static final float CAMO_HIGHLIGHT_SIZE = 0.75f;
    private static final float[] COLS = new float[]{0.5f, 0.5f, 1.0f, 0.25f};

    public ModularRouterBER(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ModularRouterBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        Vec3 routerVec = Vec3.m_82512_((Vec3i)te.m_58899_());
        for (BeamData beam : te.beams) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(-routerVec.m_7096_(), -routerVec.m_7098_(), -routerVec.m_7094_());
            Vec3 startPos = beam.getStart(routerVec);
            Vec3 endPos = beam.getEnd(routerVec);
            float progress = beam.getProgress(partialTicks);
            if (((Boolean)ConfigHolder.client.misc.renderFlyingItems.get()).booleanValue()) {
                this.renderFlyingItem(beam, matrixStack, buffer, progress, startPos, endPos);
            }
            this.renderBeamLine(beam, matrixStack, buffer, progress, startPos, endPos);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (((Boolean)ConfigHolder.client.misc.heldRouterShowsCamoRouters.get()).booleanValue() && te.getCamouflage() != null && ModularRouterBER.playerHoldingRouter((Player)player) && Vec3.m_82512_((Vec3i)te.m_58899_()).m_82557_(player.m_20182_()) < 256.0) {
            this.renderCamoHighlight(matrixStack, buffer);
        }
    }

    private void renderCamoHighlight(PoseStack poseStack, MultiBufferSource buffer) {
        poseStack.m_85836_();
        double start = 0.125;
        poseStack.m_85837_(start, start, start);
        this.addVertices(buffer.m_6299_(ModRenderTypes.BLOCK_HILIGHT_FACE), poseStack.m_85850_().m_252922_());
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_(ModRenderTypes.BLOCK_HILIGHT_LINE), (double)0.0, (double)0.0, (double)0.0, (double)0.75, (double)0.75, (double)0.75, (float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private void addVertices(VertexConsumer wr, Matrix4f posMat) {
        wr.m_252986_(posMat, 0.0f, 0.0f, 0.0f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        wr.m_252986_(posMat, 0.0f, 0.75f, 0.0f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        wr.m_252986_(posMat, 0.75f, 0.75f, 0.0f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        wr.m_252986_(posMat, 0.75f, 0.0f, 0.0f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        wr.m_252986_(posMat, 0.75f, 0.0f, 0.75f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        wr.m_252986_(posMat, 0.75f, 0.75f, 0.75f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        wr.m_252986_(posMat, 0.0f, 0.75f, 0.75f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        wr.m_252986_(posMat, 0.0f, 0.0f, 0.75f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        wr.m_252986_(posMat, 0.0f, 0.0f, 0.0f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.0f, 0.0f, 0.75f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.0f, 0.75f, 0.75f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.0f, 0.75f, 0.0f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.75f, 0.75f, 0.0f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.75f, 0.75f, 0.75f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.75f, 0.0f, 0.75f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.75f, 0.0f, 0.0f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.0f, 0.0f, 0.0f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.75f, 0.0f, 0.0f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.75f, 0.0f, 0.75f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.0f, 0.0f, 0.75f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.0f, 0.75f, 0.75f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.75f, 0.75f, 0.75f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.75f, 0.75f, 0.0f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        wr.m_252986_(posMat, 0.0f, 0.75f, 0.0f).m_85950_(COLS[0], COLS[1], COLS[2], COLS[3]).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static boolean playerHoldingRouter(Player player) {
        Item router = ((ModularRouterBlock)((Object)ModBlocks.MODULAR_ROUTER.get())).m_5456_();
        return player.m_21205_().m_41720_() == router || player.m_21206_().m_41720_() == router;
    }

    private void renderFlyingItem(BeamData beam, PoseStack matrixStack, MultiBufferSource buffer, float progress, Vec3 startPos, Vec3 endPos) {
        double iz;
        double iy;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        double ix = Mth.m_14139_((double)progress, (double)startPos.m_7096_(), (double)endPos.m_7096_());
        BlockPos pos = BlockPos.m_274561_((double)ix, (double)(iy = Mth.m_14139_((double)progress, (double)startPos.m_7098_(), (double)endPos.m_7098_())), (double)(iz = Mth.m_14139_((double)progress, (double)startPos.m_7094_(), (double)endPos.m_7094_())));
        VoxelShape shape = world.m_8055_(pos).m_60812_((BlockGetter)world, pos);
        if (shape.m_83281_() || !shape.m_83215_().m_82338_(pos).m_82393_(ix, iy, iz)) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(ix, iy - 0.15, iz);
            matrixStack.m_252781_(Axis.m_253057_((Vector3f)ROTATION).m_252977_(progress * 360.0f));
            if (beam.isItemFade()) {
                matrixStack.m_85837_(0.0, 0.15, 0.0);
                matrixStack.m_85841_(1.15f - progress, 1.15f - progress, 1.15f - progress);
                if ((double)progress > 0.95 && world.f_46441_.m_188503_(3) == 0) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, endPos.m_7096_(), endPos.m_7098_(), endPos.m_7094_(), 0.5 - world.f_46441_.m_188500_(), -0.5, 0.5 - world.f_46441_.m_188500_());
                }
            }
            Minecraft.m_91087_().m_91291_().m_269128_(beam.getStack(), ItemDisplayContext.GROUND, 0xF000F0, OverlayTexture.f_118083_, matrixStack, buffer, (Level)world, 0);
            matrixStack.m_85849_();
        }
    }

    private void renderBeamLine(BeamData beam, PoseStack matrixStack, MultiBufferSource buffer, float progress, Vec3 startPos, Vec3 endPos) {
        int alpha = (int)(Mth.m_14031_((float)((float)(Minecraft.m_91087_().f_91073_.m_46467_() % 20L) / 20.0f * (float)Math.PI)) * 128.0f + 32.0f);
        int[] colors = beam.getRGB();
        Matrix4f positionMatrix = matrixStack.m_85850_().m_252922_();
        double len = startPos.m_82554_(endPos);
        float xn = (float)((endPos.f_82479_ - startPos.f_82479_) / len);
        float yn = (float)((endPos.f_82480_ - startPos.f_82480_) / len);
        float zn = (float)((endPos.f_82481_ - startPos.f_82481_) / len);
        VertexConsumer builder = buffer.m_6299_(ModRenderTypes.BEAM_LINE_THICK);
        ClientUtil.posF(builder, positionMatrix, startPos).m_6122_(colors[0], colors[1], colors[2], alpha).m_252939_(matrixStack.m_85850_().m_252943_(), xn, yn, zn).m_5752_();
        ClientUtil.posF(builder, positionMatrix, endPos).m_6122_(colors[0], colors[1], colors[2], alpha).m_252939_(matrixStack.m_85850_().m_252943_(), xn, yn, zn).m_5752_();
        VertexConsumer builder2 = buffer.m_6299_(ModRenderTypes.BEAM_LINE_THIN);
        ClientUtil.posF(builder2, positionMatrix, startPos).m_6122_(colors[0], colors[1], colors[2], 192).m_252939_(matrixStack.m_85850_().m_252943_(), xn, yn, zn).m_5752_();
        ClientUtil.posF(builder2, positionMatrix, endPos).m_6122_(colors[0], colors[1], colors[2], 192).m_252939_(matrixStack.m_85850_().m_252943_(), xn, yn, zn).m_5752_();
    }
}

