/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.lib;

import com.jerry.mekanism_extras.lib.BlockInfo;
import java.util.List;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;

public record NBTStructureFile(List<CompoundTag> blocks, List<CompoundTag> entities, List<CompoundTag> palette, int[] size) {
    public static NBTStructureFile fromNBTTag(CompoundTag nbt) {
        return new NBTStructureFile(nbt.m_128437_("blocks", 10).stream().map(tag -> (CompoundTag)tag).toList(), nbt.m_128437_("entities", 10).stream().map(tag -> (CompoundTag)tag).toList(), nbt.m_128437_("palette", 10).stream().map(tag -> (CompoundTag)tag).toList(), nbt.m_128465_("size"));
    }

    @NothingNullByDefault
    public BlockInfo getBlockInfo(int x, int y, int z) throws IndexOutOfBoundsException {
        if (x > this.size[0] - 1 || y > this.size[1] - 1 || z > this.size[2] - 1) {
            throw new IndexOutOfBoundsException();
        }
        CompoundTag blockToGet = null;
        for (CompoundTag b : this.blocks) {
            ListTag pos = b.m_128437_("pos", 11);
            int x0 = pos.m_128763_(0);
            int y0 = pos.m_128763_(1);
            int z0 = pos.m_128763_(2);
            if (x != x0 || y != y0 || z != z0) continue;
            blockToGet = b;
            break;
        }
        return new BlockInfo(blockToGet.m_128469_("nbt"), this.palette.get(blockToGet.m_128451_("palette")));
    }
}

