/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tile.transmitter;

import com.jerry.mekanism_extras.api.tier.AdvancedTier;
import com.jerry.mekanism_extras.common.content.network.transmitter.ExtraUniversalCable;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityTransmitter;
import java.util.Collections;
import java.util.List;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.ISidedStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.energy.DynamicStrictEnergyHandler;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.capabilities.resolver.manager.EnergyHandlerManager;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.integration.computer.ComputerCapabilityHelper;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraTileEntityUniversalCable
extends ExtraTileEntityTransmitter
implements IComputerTile {
    private final EnergyHandlerManager energyHandlerManager = new EnergyHandlerManager(direction -> {
        ExtraUniversalCable cable = this.getTransmitter();
        if (direction != null && cable.getConnectionTypeRaw(direction) == ConnectionType.NONE || cable.isRedstoneActivated()) {
            return Collections.emptyList();
        }
        return cable.getEnergyContainers(direction);
    }, (ISidedStrictEnergyHandler)new DynamicStrictEnergyHandler(this::getEnergyContainers, this.getExtractPredicate(), this.getInsertPredicate(), null));

    public ExtraTileEntityUniversalCable(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver((ICapabilityResolver)this.energyHandlerManager);
        ComputerCapabilityHelper.addComputerCapabilities((BlockEntity)this, x$0 -> this.addCapabilityResolver((ICapabilityResolver)x$0));
    }

    protected ExtraUniversalCable createTransmitter(IBlockProvider blockProvider) {
        return new ExtraUniversalCable(blockProvider, this);
    }

    public ExtraUniversalCable getTransmitter() {
        return (ExtraUniversalCable)super.getTransmitter();
    }

    protected void onUpdateServer() {
        this.getTransmitter().pullFromAcceptors();
        super.onUpdateServer();
    }

    public TransmitterType getTransmitterType() {
        return TransmitterType.UNIVERSAL_CABLE;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull AdvancedTier tier) {
        return BlockStateHelper.copyStateData((BlockState)current, switch (tier) {
            case AdvancedTier.ABSOLUTE -> ExtraBlock.ABSOLUTE_UNIVERSAL_CABLE;
            case AdvancedTier.SUPREME -> ExtraBlock.SUPREME_UNIVERSAL_CABLE;
            case AdvancedTier.COSMIC -> ExtraBlock.COSMIC_UNIVERSAL_CABLE;
            case AdvancedTier.INFINITE -> ExtraBlock.INFINITE_UNIVERSAL_CABLE;
            default -> null;
        });
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            EnergyNetwork network = (EnergyNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.m_128359_("energy", network.energyContainer.getEnergy().toString());
            updateTag.m_128350_("scale", network.currentScale);
        }
        return updateTag;
    }

    private List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyHandlerManager.getContainers(side);
    }

    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapabilities(EnergyCompatUtils.getEnabledEnergyCapabilities(), side);
            WorldUtils.notifyNeighborOfChange((Level)this.f_58857_, (Direction)side, (BlockPos)this.f_58858_);
        } else if (old == ConnectionType.NONE) {
            WorldUtils.notifyNeighborOfChange((Level)this.f_58857_, (Direction)side, (BlockPos)this.f_58858_);
        }
    }

    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapabilities(EnergyCompatUtils.getEnabledEnergyCapabilities(), EnumUtils.DIRECTIONS);
        }
    }

    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "UniversalCable";
    }

    @ComputerMethod
    FloatingLong getBuffer() {
        return this.getTransmitter().getBufferWithFallback();
    }

    @ComputerMethod
    FloatingLong getCapacity() {
        ExtraUniversalCable cable = this.getTransmitter();
        return cable.hasTransmitterNetwork() ? ((EnergyNetwork)cable.getTransmitterNetwork()).getCapacityAsFloatingLong() : cable.getCapacityAsFloatingLong();
    }

    @ComputerMethod
    FloatingLong getNeeded() {
        return this.getCapacity().subtract(this.getBuffer());
    }

    @ComputerMethod
    double getFilledPercentage() {
        return this.getBuffer().divideToLevel(this.getCapacity());
    }
}

