/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tile.transmitter;

import com.jerry.mekanism_extras.api.tier.AdvancedTier;
import com.jerry.mekanism_extras.common.content.network.transmitter.ExtraThermodynamicConductor;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityTransmitter;
import java.util.Collections;
import java.util.List;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.api.heat.ISidedHeatHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.capabilities.resolver.manager.HeatHandlerManager;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraTileEntityThermodynamicConductor
extends ExtraTileEntityTransmitter {
    private final HeatHandlerManager heatHandlerManager = new HeatHandlerManager(direction -> {
        ExtraThermodynamicConductor conductor = this.getTransmitter();
        if (direction != null && conductor.getConnectionTypeRaw(direction) == ConnectionType.NONE || conductor.isRedstoneActivated()) {
            return Collections.emptyList();
        }
        return conductor.getHeatCapacitors(direction);
    }, (ISidedHeatHandler)new IMekanismHeatHandler(){

        @NotNull
        public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction side) {
            return ExtraTileEntityThermodynamicConductor.this.heatHandlerManager.getContainers(side);
        }

        public void onContentsChanged() {
        }
    });

    public ExtraTileEntityThermodynamicConductor(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver((ICapabilityResolver)this.heatHandlerManager);
    }

    protected ExtraThermodynamicConductor createTransmitter(IBlockProvider blockProvider) {
        return new ExtraThermodynamicConductor(blockProvider, this);
    }

    public ExtraThermodynamicConductor getTransmitter() {
        return (ExtraThermodynamicConductor)super.getTransmitter();
    }

    public TransmitterType getTransmitterType() {
        return TransmitterType.THERMODYNAMIC_CONDUCTOR;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull AdvancedTier tier) {
        return BlockStateHelper.copyStateData((BlockState)current, switch (tier) {
            case AdvancedTier.ABSOLUTE -> ExtraBlock.ABSOLUTE_THERMODYNAMIC_CONDUCTOR;
            case AdvancedTier.SUPREME -> ExtraBlock.SUPREME_THERMODYNAMIC_CONDUCTOR;
            case AdvancedTier.COSMIC -> ExtraBlock.COSMIC_THERMODYNAMIC_CONDUCTOR;
            case AdvancedTier.INFINITE -> ExtraBlock.INFINITE_THERMODYNAMIC_CONDUCTOR;
            default -> null;
        });
    }

    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapability(Capabilities.HEAT_HANDLER, side);
            WorldUtils.notifyNeighborOfChange((Level)this.f_58857_, (Direction)side, (BlockPos)this.f_58858_);
        } else if (old == ConnectionType.NONE) {
            WorldUtils.notifyNeighborOfChange((Level)this.f_58857_, (Direction)side, (BlockPos)this.f_58858_);
        }
    }

    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapability(Capabilities.HEAT_HANDLER, EnumUtils.DIRECTIONS);
        }
    }
}

