/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tile;

import com.jerry.mekanism_extras.common.block.attribute.ExtraAttribute;
import com.jerry.mekanism_extras.common.inventory.slot.ExtraBinInventorySlot;
import com.jerry.mekanism_extras.common.tier.BTier;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityLogisticalTransporterBase;
import com.jerry.mekanism_extras.common.upgrade.ExtraBinUpgradeData;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.lib.inventory.TileTransitRequest;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.upgrade.BinUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class ExtraTileEntityBin
extends TileEntityMekanism
implements IConfigurable {
    public int addTicks = 0;
    public int removeTicks = 0;
    private int delayTicks;
    private BTier tier;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getStored"}, docPlaceholder="bin")
    ExtraBinInventorySlot binSlot;

    public ExtraTileEntityBin(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.CONFIGURABLE, (Object)((Object)this)));
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = ExtraAttribute.getTier(this.getBlockType(), BTier.class);
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((ExtraTileEntityBin)this).getDirection());
        this.binSlot = ExtraBinInventorySlot.create(listener, this.tier);
        builder.addSlot((IInventorySlot)this.binSlot);
        return builder.build();
    }

    public BTier getTier() {
        return this.tier;
    }

    public int getItemCount() {
        return this.binSlot.getCount();
    }

    public ExtraBinInventorySlot getBinSlot() {
        return this.binSlot;
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.addTicks = Math.max(0, this.addTicks - 1);
        this.removeTicks = Math.max(0, this.removeTicks - 1);
        this.delayTicks = Math.max(0, this.delayTicks - 1);
        if (this.delayTicks == 0) {
            if (this.getActive()) {
                TransitRequest.TransitResponse response;
                BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), (BlockPos)this.m_58899_().m_7495_());
                TileTransitRequest request = new TileTransitRequest((BlockEntity)this, Direction.DOWN);
                request.addItem(this.binSlot.getBottomStack(), 0);
                if (tile instanceof ExtraTileEntityLogisticalTransporterBase) {
                    ExtraTileEntityLogisticalTransporterBase transporter = (ExtraTileEntityLogisticalTransporterBase)tile;
                    response = transporter.getTransmitter().insert((BlockEntity)this, (TransitRequest)request, transporter.getTransmitter().getColor(), true, 0);
                } else {
                    response = request.addToInventory(tile, Direction.DOWN, 0, false);
                }
                if (!response.isEmpty()) {
                    int sendingAmount = response.getSendingAmount();
                    MekanismUtils.logMismatchedStackSize((long)this.binSlot.shrinkStack(sendingAmount, Action.EXECUTE), (long)sendingAmount);
                }
                this.delayTicks = 10;
            }
        } else {
            --this.delayTicks;
        }
    }

    public InteractionResult onSneakRightClick(Player player) {
        this.setActive(!this.getActive());
        Level world = this.m_58904_();
        if (world != null) {
            world.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (SoundEvent)SoundEvents.f_12490_.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    public boolean toggleLock() {
        return this.setLocked(!this.binSlot.isLocked());
    }

    public boolean setLocked(boolean isLocked) {
        if (this.binSlot.setLocked(isLocked)) {
            if (this.m_58904_() != null && !this.isRemote()) {
                this.sendUpdatePacket();
                this.markForSave();
                this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (SoundEvent)SoundEvents.f_12490_.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ExtraBinUpgradeData) {
            ExtraBinUpgradeData data = (ExtraBinUpgradeData)upgradeData;
            this.redstone = data.redstone();
            ExtraBinInventorySlot previous = data.binSlot();
            this.binSlot.setStack(previous.getStack());
            this.binSlot.setLockStack(previous.getLockStack());
        } else if (upgradeData instanceof BinUpgradeData) {
            BinUpgradeData data = (BinUpgradeData)upgradeData;
            this.redstone = data.redstone();
            BinInventorySlot previous = data.binSlot();
            this.binSlot.setStack(previous.getStack());
            this.binSlot.setLockStack(previous.getLockStack());
            this.binSlot.deserializeNBT(previous.serializeNBT());
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @NotNull
    public ExtraBinUpgradeData getUpgradeData() {
        return new ExtraBinUpgradeData(this.redstone, this.getBinSlot());
    }

    public void onContentsChanged() {
        super.onContentsChanged();
        if (this.f_58857_ != null && !this.isRemote()) {
            this.sendUpdatePacket();
        }
    }

    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.m_128365_("Item", (Tag)this.binSlot.serializeNBT());
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setCompoundIfPresent((CompoundTag)tag, (String)"Item", nbt -> this.binSlot.deserializeNBT((CompoundTag)nbt));
    }

    @ComputerMethod(methodDescription="Get the maximum number of items the bin can contain.")
    int getCapacity() {
        return this.binSlot.getLimit(this.binSlot.getStack());
    }

    @ComputerMethod(methodDescription="If true, the Bin is locked to a particular item type.")
    boolean isLocked() {
        return this.binSlot.isLocked();
    }

    @ComputerMethod(methodDescription="Get the type of item the Bin is locked to (or Air if not locked)")
    ItemStack getLock() {
        return this.binSlot.getLockStack();
    }

    @ComputerMethod(methodDescription="Lock the Bin to the currently stored item type. The Bin must not be creative, empty, or already locked")
    void lock() throws ComputerException {
        if (this.binSlot.isEmpty()) {
            throw new ComputerException("Empty bins cannot be locked!");
        }
        if (!this.setLocked(true)) {
            throw new ComputerException("This bin is already locked!");
        }
    }

    @ComputerMethod(methodDescription="Unlock the Bin's fixed item type. The Bin must not be creative, or already unlocked")
    void unlock() throws ComputerException {
        if (!this.setLocked(true)) {
            throw new ComputerException("This bin is not locked!");
        }
    }
}

