/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.registry;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekanism_extras.api.tier.IAdvancedTier;
import com.jerry.mekanism_extras.common.block.ExtraBlockEnergyCube;
import com.jerry.mekanism_extras.common.block.ExtraBlockOre;
import com.jerry.mekanism_extras.common.block.ExtraBlockRadioactiveWasteBarrel;
import com.jerry.mekanism_extras.common.block.attribute.ExtraAttributeTier;
import com.jerry.mekanism_extras.common.block.basic.ExtraBlockBin;
import com.jerry.mekanism_extras.common.block.basic.ExtraBlockFluidTank;
import com.jerry.mekanism_extras.common.block.basic.ExtraBlockResource;
import com.jerry.mekanism_extras.common.block.prefab.BlockAdvancedFactoryMachine;
import com.jerry.mekanism_extras.common.block.transmitter.ExtraBlockLogisticalTransporter;
import com.jerry.mekanism_extras.common.block.transmitter.ExtraBlockMechanicalPipe;
import com.jerry.mekanism_extras.common.block.transmitter.ExtraBlockPressurizedTube;
import com.jerry.mekanism_extras.common.block.transmitter.ExtraBlockThermodynamicConductor;
import com.jerry.mekanism_extras.common.block.transmitter.ExtraBlockUniversalCable;
import com.jerry.mekanism_extras.common.content.blocktype.AdvancedFactory;
import com.jerry.mekanism_extras.common.integration.Addons;
import com.jerry.mekanism_extras.common.item.block.ExtraItemBlockBin;
import com.jerry.mekanism_extras.common.item.block.ExtraItemBlockChemicalTank;
import com.jerry.mekanism_extras.common.item.block.ExtraItemBlockEnergyCube;
import com.jerry.mekanism_extras.common.item.block.ExtraItemBlockInductionCell;
import com.jerry.mekanism_extras.common.item.block.ExtraItemBlockInductionProvider;
import com.jerry.mekanism_extras.common.item.block.ExtraItemBlockRadioactiveWasteBarrel;
import com.jerry.mekanism_extras.common.item.block.ExtraItemBlockResource;
import com.jerry.mekanism_extras.common.item.block.machine.ExtraItemBlockFluidTank;
import com.jerry.mekanism_extras.common.item.block.machine.ItemBlockAdvancedFactory;
import com.jerry.mekanism_extras.common.item.block.transmitter.ExtraItemBlockLogisticalTransporter;
import com.jerry.mekanism_extras.common.item.block.transmitter.ExtraItemBlockMechanicalPipe;
import com.jerry.mekanism_extras.common.item.block.transmitter.ExtraItemBlockPressurizedTube;
import com.jerry.mekanism_extras.common.item.block.transmitter.ExtraItemBlockThermodynamicConductor;
import com.jerry.mekanism_extras.common.item.block.transmitter.ExtraItemBlockUniversalCable;
import com.jerry.mekanism_extras.common.registry.ExtraBlockType;
import com.jerry.mekanism_extras.common.resource.ExtraBlockResourceInfo;
import com.jerry.mekanism_extras.common.resource.ore.ExtraOreBlockType;
import com.jerry.mekanism_extras.common.resource.ore.ExtraOreType;
import com.jerry.mekanism_extras.common.tier.AdvancedFactoryTier;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityBin;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityChemicalTank;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityEnergyCube;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityFluidTank;
import com.jerry.mekanism_extras.common.tile.factory.TileEntityExtraFactory;
import com.jerry.mekanism_extras.common.tile.machine.TileEntityAdvancedElectricPump;
import com.jerry.mekanism_extras.common.tile.multiblock.ExtraTileEntityInductionCell;
import com.jerry.mekanism_extras.common.tile.multiblock.ExtraTileEntityInductionProvider;
import com.jerry.mekanism_extras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import com.jerry.mekanism_extras.common.tile.multiblock.TileEntityReinforcedInductionPort;
import com.jerry.mekanism_extras.common.util.ExtraEnumUtils;
import fr.iglee42.evolvedmekanism.registries.EMFactoryType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.tier.ITier;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.prefab.BlockBasicMultiblock;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.block.machine.ItemBlockMachine;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.tier.CableTier;
import mekanism.common.tier.ConductorTier;
import mekanism.common.tier.PipeTier;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tier.TubeTier;
import mekanism.common.util.EnumUtils;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

public class ExtraBlock {
    public static final BlockDeferredRegister EXTRA_BLOCK = new BlockDeferredRegister("mekanism_extras");
    public static final Map<ExtraOreType, ExtraOreBlockType> ORES = new LinkedHashMap<ExtraOreType, ExtraOreBlockType>();
    private static final Table<AdvancedFactoryTier, FactoryType, BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory>> FACTORIES = HashBasedTable.create();
    public static final BlockRegistryObject<ExtraBlockResource, ExtraItemBlockResource> NAQUADAH_BLOCK;
    public static final BlockRegistryObject<ExtraBlockResource, ExtraItemBlockResource> RAW_NAQUADAH_BLOCK;
    public static final BlockRegistryObject<ExtraBlockBin, ExtraItemBlockBin> ABSOLUTE_BIN;
    public static final BlockRegistryObject<ExtraBlockBin, ExtraItemBlockBin> SUPREME_BIN;
    public static final BlockRegistryObject<ExtraBlockBin, ExtraItemBlockBin> COSMIC_BIN;
    public static final BlockRegistryObject<ExtraBlockBin, ExtraItemBlockBin> INFINITE_BIN;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityReinforcedInductionCasing>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityReinforcedInductionCasing>>> REINFORCED_INDUCTION_CASING;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityReinforcedInductionPort>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityReinforcedInductionPort>>> REINFORCED_INDUCTION_PORT;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionCell, BlockTypeTile<ExtraTileEntityInductionCell>>, ExtraItemBlockInductionCell> ABSOLUTE_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionCell, BlockTypeTile<ExtraTileEntityInductionCell>>, ExtraItemBlockInductionCell> SUPREME_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionCell, BlockTypeTile<ExtraTileEntityInductionCell>>, ExtraItemBlockInductionCell> COSMIC_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionCell, BlockTypeTile<ExtraTileEntityInductionCell>>, ExtraItemBlockInductionCell> INFINITE_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionProvider, BlockTypeTile<ExtraTileEntityInductionProvider>>, ExtraItemBlockInductionProvider> ABSOLUTE_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionProvider, BlockTypeTile<ExtraTileEntityInductionProvider>>, ExtraItemBlockInductionProvider> SUPREME_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionProvider, BlockTypeTile<ExtraTileEntityInductionProvider>>, ExtraItemBlockInductionProvider> COSMIC_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionProvider, BlockTypeTile<ExtraTileEntityInductionProvider>>, ExtraItemBlockInductionProvider> INFINITE_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<ExtraBlockFluidTank, ExtraItemBlockFluidTank> ABSOLUTE_FLUID_TANK;
    public static final BlockRegistryObject<ExtraBlockFluidTank, ExtraItemBlockFluidTank> SUPREME_FLUID_TANK;
    public static final BlockRegistryObject<ExtraBlockFluidTank, ExtraItemBlockFluidTank> COSMIC_FLUID_TANK;
    public static final BlockRegistryObject<ExtraBlockFluidTank, ExtraItemBlockFluidTank> INFINITE_FLUID_TANK;
    public static final BlockRegistryObject<ExtraBlockEnergyCube, ExtraItemBlockEnergyCube> ABSOLUTE_ENERGY_CUBE;
    public static final BlockRegistryObject<ExtraBlockEnergyCube, ExtraItemBlockEnergyCube> SUPREME_ENERGY_CUBE;
    public static final BlockRegistryObject<ExtraBlockEnergyCube, ExtraItemBlockEnergyCube> COSMIC_ENERGY_CUBE;
    public static final BlockRegistryObject<ExtraBlockEnergyCube, ExtraItemBlockEnergyCube> INFINITE_ENERGY_CUBE;
    public static final BlockRegistryObject<ExtraBlockUniversalCable, ExtraItemBlockUniversalCable> ABSOLUTE_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<ExtraBlockUniversalCable, ExtraItemBlockUniversalCable> SUPREME_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<ExtraBlockUniversalCable, ExtraItemBlockUniversalCable> COSMIC_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<ExtraBlockUniversalCable, ExtraItemBlockUniversalCable> INFINITE_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<ExtraBlockMechanicalPipe, ExtraItemBlockMechanicalPipe> ABSOLUTE_MECHANICAL_PIPE;
    public static final BlockRegistryObject<ExtraBlockMechanicalPipe, ExtraItemBlockMechanicalPipe> SUPREME_MECHANICAL_PIPE;
    public static final BlockRegistryObject<ExtraBlockMechanicalPipe, ExtraItemBlockMechanicalPipe> COSMIC_MECHANICAL_PIPE;
    public static final BlockRegistryObject<ExtraBlockMechanicalPipe, ExtraItemBlockMechanicalPipe> INFINITE_MECHANICAL_PIPE;
    public static final BlockRegistryObject<ExtraBlockPressurizedTube, ExtraItemBlockPressurizedTube> ABSOLUTE_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<ExtraBlockPressurizedTube, ExtraItemBlockPressurizedTube> SUPREME_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<ExtraBlockPressurizedTube, ExtraItemBlockPressurizedTube> COSMIC_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<ExtraBlockPressurizedTube, ExtraItemBlockPressurizedTube> INFINITE_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<ExtraBlockLogisticalTransporter, ExtraItemBlockLogisticalTransporter> ABSOLUTE_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<ExtraBlockLogisticalTransporter, ExtraItemBlockLogisticalTransporter> SUPREME_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<ExtraBlockLogisticalTransporter, ExtraItemBlockLogisticalTransporter> COSMIC_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<ExtraBlockLogisticalTransporter, ExtraItemBlockLogisticalTransporter> INFINITE_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<ExtraBlockThermodynamicConductor, ExtraItemBlockThermodynamicConductor> ABSOLUTE_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<ExtraBlockThermodynamicConductor, ExtraItemBlockThermodynamicConductor> SUPREME_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<ExtraBlockThermodynamicConductor, ExtraItemBlockThermodynamicConductor> COSMIC_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<ExtraBlockThermodynamicConductor, ExtraItemBlockThermodynamicConductor> INFINITE_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<ExtraTileEntityChemicalTank, Machine<ExtraTileEntityChemicalTank>>, ExtraItemBlockChemicalTank> ABSOLUTE_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<ExtraTileEntityChemicalTank, Machine<ExtraTileEntityChemicalTank>>, ExtraItemBlockChemicalTank> SUPREME_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<ExtraTileEntityChemicalTank, Machine<ExtraTileEntityChemicalTank>>, ExtraItemBlockChemicalTank> COSMIC_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<ExtraTileEntityChemicalTank, Machine<ExtraTileEntityChemicalTank>>, ExtraItemBlockChemicalTank> INFINITE_CHEMICAL_TANK;
    public static final BlockRegistryObject<ExtraBlockRadioactiveWasteBarrel, ExtraItemBlockRadioactiveWasteBarrel> EXPAND_RADIOACTIVE_WASTE_BARREL;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityAdvancedElectricPump, Machine<TileEntityAdvancedElectricPump>>, ItemBlockMachine> ADVANCED_ELECTRIC_PUMP;

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(String tierName, String suffix, Supplier<? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        return EXTRA_BLOCK.register(tierName + suffix, blockSupplier, itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(BlockType type, String registerName, Function<MapColor, ? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        ITier tier = Objects.requireNonNull((AttributeTier)type.get(AttributeTier.class)).tier();
        return EXTRA_BLOCK.register(registerName, () -> (Block)blockSupplier.apply(tier.getBaseTier().getMapColor()), itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock_1(BlockType type, String registerName, Function<MapColor, ? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        Object tier = Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return EXTRA_BLOCK.register(registerName, () -> (Block)blockSupplier.apply(tier.getAdvanceTier().getMapColor()), itemCreator);
    }

    private static ExtraOreBlockType registerOre(ExtraOreType ore) {
        String name = ore.getResource().getRegistrySuffix() + "_ore";
        BlockRegistryObject<ExtraBlockOre, ItemBlockTooltip<ExtraBlockOre>> stoneOre = ExtraBlock.registerBlock(name, () -> new ExtraBlockOre(ore));
        return new ExtraOreBlockType(stoneOre);
    }

    private static BlockRegistryObject<ExtraBlockResource, ExtraItemBlockResource> registerResourceBlock(ExtraBlockResourceInfo resource) {
        return EXTRA_BLOCK.registerDefaultProperties("block_" + resource.getRegistrySuffix(), () -> new ExtraBlockResource(resource), (block, properties) -> {
            if (!block.getResourceInfo().burnsInFire()) {
                properties = properties.m_41486_();
            }
            return new ExtraItemBlockResource((ExtraBlockResource)((Object)block), (Item.Properties)properties);
        });
    }

    private static BlockRegistryObject<ExtraBlockBin, ExtraItemBlockBin> registerBin(String tileName, BlockTypeTile<ExtraTileEntityBin> type) {
        return ExtraBlock.registerTieredBlock_1(type, tileName + "_bin", color -> new ExtraBlockBin(type, properties -> properties.m_284180_(color)), ExtraItemBlockBin::new);
    }

    private static BlockRegistryObject<BlockTile<ExtraTileEntityInductionCell, BlockTypeTile<ExtraTileEntityInductionCell>>, ExtraItemBlockInductionCell> registerInductionCell(String tileName, BlockTypeTile<ExtraTileEntityInductionCell> type) {
        return ExtraBlock.registerTieredBlock(type, tileName + "_induction_cell", (MapColor color) -> new BlockTile(type, properties -> properties.m_284180_(color)), ExtraItemBlockInductionCell::new);
    }

    private static BlockRegistryObject<BlockTile<ExtraTileEntityInductionProvider, BlockTypeTile<ExtraTileEntityInductionProvider>>, ExtraItemBlockInductionProvider> registerInductionProvider(String tileName, BlockTypeTile<ExtraTileEntityInductionProvider> type) {
        return ExtraBlock.registerTieredBlock(type, tileName + "_induction_provider", (MapColor color) -> new BlockTile(type, properties -> properties.m_284180_(color)), ExtraItemBlockInductionProvider::new);
    }

    private static BlockRegistryObject<ExtraBlockFluidTank, ExtraItemBlockFluidTank> registerFluidTank(String tileName, Machine<ExtraTileEntityFluidTank> type) {
        return ExtraBlock.registerTieredBlock(tileName, "_fluid_tank", () -> new ExtraBlockFluidTank(type), ExtraItemBlockFluidTank::new);
    }

    private static BlockRegistryObject<ExtraBlockEnergyCube, ExtraItemBlockEnergyCube> registerEnergyCube(String tileName, Machine<ExtraTileEntityEnergyCube> type) {
        return ExtraBlock.registerTieredBlock(tileName, "_energy_cube", () -> new ExtraBlockEnergyCube(type), ExtraItemBlockEnergyCube::new);
    }

    private static BlockRegistryObject<ExtraBlockUniversalCable, ExtraItemBlockUniversalCable> registerUniversalCable(String tileName, CableTier tier) {
        return ExtraBlock.registerTieredBlock(tileName, "_universal_cable", () -> new ExtraBlockUniversalCable(tier), ExtraItemBlockUniversalCable::new);
    }

    private static BlockRegistryObject<ExtraBlockMechanicalPipe, ExtraItemBlockMechanicalPipe> registerMechanicalPipe(String tileName, PipeTier tier) {
        return ExtraBlock.registerTieredBlock(tileName, "_mechanical_pipe", () -> new ExtraBlockMechanicalPipe(tier), ExtraItemBlockMechanicalPipe::new);
    }

    private static BlockRegistryObject<ExtraBlockPressurizedTube, ExtraItemBlockPressurizedTube> registerPressurizedTube(String tileName, TubeTier tier) {
        return ExtraBlock.registerTieredBlock(tileName, "_pressurized_tube", () -> new ExtraBlockPressurizedTube(tier), ExtraItemBlockPressurizedTube::new);
    }

    private static BlockRegistryObject<ExtraBlockLogisticalTransporter, ExtraItemBlockLogisticalTransporter> registerLogisticalTransporter(String tileName, TransporterTier tier) {
        return ExtraBlock.registerTieredBlock(tileName, "_logistical_transporter", () -> new ExtraBlockLogisticalTransporter(tier), ExtraItemBlockLogisticalTransporter::new);
    }

    private static BlockRegistryObject<ExtraBlockThermodynamicConductor, ExtraItemBlockThermodynamicConductor> registerThermodynamicConductor(String tileName, ConductorTier tier) {
        return ExtraBlock.registerTieredBlock(tileName, "_thermodynamic_conductor", () -> new ExtraBlockThermodynamicConductor(tier), ExtraItemBlockThermodynamicConductor::new);
    }

    private static BlockRegistryObject<BlockTile.BlockTileModel<ExtraTileEntityChemicalTank, Machine<ExtraTileEntityChemicalTank>>, ExtraItemBlockChemicalTank> registerChemicalTank(String tileName, Machine<ExtraTileEntityChemicalTank> type) {
        return ExtraBlock.registerTieredBlock_1(type, tileName + "_chemical_tank", color -> new BlockTile.BlockTileModel((BlockTypeTile)type, properties -> properties.m_284180_(color)), ExtraItemBlockChemicalTank::new);
    }

    private static <BLOCK extends Block> BlockRegistryObject<BLOCK, ItemBlockTooltip<BLOCK>> registerBlock(String name, Supplier<? extends BLOCK> blockSupplier) {
        return EXTRA_BLOCK.registerDefaultProperties(name, blockSupplier, (x$0, x$1) -> new ItemBlockTooltip((Block)x$0, x$1));
    }

    private static <TILE extends TileEntityExtraFactory<?>> BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory> registerFactory(AdvancedFactory<TILE> type) {
        Object tier = Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlock.registerTieredBlock(type, "_" + type.getFactoryType().getRegistryNameComponent() + "_factory", () -> new BlockAdvancedFactoryMachine.BlockAdvancedFactory(type), ItemBlockAdvancedFactory::new);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(BlockType type, String suffix, Supplier<? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        return ExtraBlock.registerTieredBlock(Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier(), suffix, blockSupplier, itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(IAdvancedTier tier, String suffix, Supplier<? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        return EXTRA_BLOCK.register(tier.getAdvanceTier().getLowerName() + suffix, blockSupplier, itemCreator);
    }

    public static BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory> getAdvancedFactory(@NotNull AdvancedFactoryTier tier, @NotNull FactoryType type) {
        return (BlockRegistryObject)FACTORIES.get((Object)tier, (Object)type);
    }

    public static BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory>[] getAdvancedFactoryBlocks() {
        return FACTORIES.values().toArray(new BlockRegistryObject[0]);
    }

    public static void register(IEventBus eventBus) {
        EXTRA_BLOCK.register(eventBus);
    }

    static {
        for (AdvancedFactoryTier advancedFactoryTier : ExtraEnumUtils.ADVANCED_FACTORY_TIERS) {
            for (FactoryType type : EnumUtils.FACTORY_TYPES) {
                if (Addons.EVOLVEDMEKANISM.isLoaded()) {
                    if (type == EMFactoryType.ALLOYING) continue;
                    FACTORIES.put((Object)advancedFactoryTier, (Object)type, ExtraBlock.registerFactory(ExtraBlockType.getAdvancedFactory(advancedFactoryTier, type)));
                    continue;
                }
                FACTORIES.put((Object)advancedFactoryTier, (Object)type, ExtraBlock.registerFactory(ExtraBlockType.getAdvancedFactory(advancedFactoryTier, type)));
            }
        }
        for (Enum enum_ : ExtraEnumUtils.ORE_TYPES) {
            ORES.put((ExtraOreType)enum_, ExtraBlock.registerOre((ExtraOreType)enum_));
        }
        NAQUADAH_BLOCK = ExtraBlock.registerResourceBlock(ExtraBlockResourceInfo.NAQUADAH);
        RAW_NAQUADAH_BLOCK = ExtraBlock.registerResourceBlock(ExtraBlockResourceInfo.RAW_NAQUADAH);
        ABSOLUTE_BIN = ExtraBlock.registerBin("absolute", ExtraBlockType.ABSOLUTE_BIN);
        SUPREME_BIN = ExtraBlock.registerBin("supreme", ExtraBlockType.SUPREME_BIN);
        COSMIC_BIN = ExtraBlock.registerBin("cosmic", ExtraBlockType.COSMIC_BIN);
        INFINITE_BIN = ExtraBlock.registerBin("infinite", ExtraBlockType.INFINITE_BIN);
        REINFORCED_INDUCTION_CASING = ExtraBlock.registerBlock("reinforced_induction_casing", () -> new BlockBasicMultiblock(ExtraBlockType.REINFORCED_INDUCTION_CASING, properties -> properties.m_284180_(MapColor.f_283779_)));
        REINFORCED_INDUCTION_PORT = ExtraBlock.registerBlock("reinforced_induction_port", () -> new BlockBasicMultiblock(ExtraBlockType.REINFORCED_INDUCTION_PORT, properties -> properties.m_284180_(MapColor.f_283779_)));
        ABSOLUTE_INDUCTION_CELL = ExtraBlock.registerInductionCell("absolute", ExtraBlockType.ABSOLUTE_INDUCTION_CELL);
        SUPREME_INDUCTION_CELL = ExtraBlock.registerInductionCell("supreme", ExtraBlockType.SUPREME_INDUCTION_CELL);
        COSMIC_INDUCTION_CELL = ExtraBlock.registerInductionCell("cosmic", ExtraBlockType.COSMIC_INDUCTION_CELL);
        INFINITE_INDUCTION_CELL = ExtraBlock.registerInductionCell("infinite", ExtraBlockType.INFINITE_INDUCTION_CELL);
        ABSOLUTE_INDUCTION_PROVIDER = ExtraBlock.registerInductionProvider("absolute", ExtraBlockType.ABSOLUTE_INDUCTION_PROVIDER);
        SUPREME_INDUCTION_PROVIDER = ExtraBlock.registerInductionProvider("supreme", ExtraBlockType.SUPREME_INDUCTION_PROVIDER);
        COSMIC_INDUCTION_PROVIDER = ExtraBlock.registerInductionProvider("cosmic", ExtraBlockType.COSMIC_INDUCTION_PROVIDER);
        INFINITE_INDUCTION_PROVIDER = ExtraBlock.registerInductionProvider("infinite", ExtraBlockType.INFINITE_INDUCTION_PROVIDER);
        ABSOLUTE_FLUID_TANK = ExtraBlock.registerFluidTank("absolute", ExtraBlockType.ABSOLUTE_FLUID_TANK);
        SUPREME_FLUID_TANK = ExtraBlock.registerFluidTank("supreme", ExtraBlockType.SUPREME_FLUID_TANK);
        COSMIC_FLUID_TANK = ExtraBlock.registerFluidTank("cosmic", ExtraBlockType.COSMIC_FLUID_TANK);
        INFINITE_FLUID_TANK = ExtraBlock.registerFluidTank("infinite", ExtraBlockType.INFINITE_FLUID_TANK);
        ABSOLUTE_ENERGY_CUBE = ExtraBlock.registerEnergyCube("absolute", ExtraBlockType.ABSOLUTE_ENERGY_CUBE);
        SUPREME_ENERGY_CUBE = ExtraBlock.registerEnergyCube("supreme", ExtraBlockType.SUPREME_ENERGY_CUBE);
        COSMIC_ENERGY_CUBE = ExtraBlock.registerEnergyCube("cosmic", ExtraBlockType.COSMIC_ENERGY_CUBE);
        INFINITE_ENERGY_CUBE = ExtraBlock.registerEnergyCube("infinite", ExtraBlockType.INFINITE_ENERGY_CUBE);
        ABSOLUTE_UNIVERSAL_CABLE = ExtraBlock.registerUniversalCable("absolute", CableTier.BASIC);
        SUPREME_UNIVERSAL_CABLE = ExtraBlock.registerUniversalCable("supreme", CableTier.ADVANCED);
        COSMIC_UNIVERSAL_CABLE = ExtraBlock.registerUniversalCable("cosmic", CableTier.ELITE);
        INFINITE_UNIVERSAL_CABLE = ExtraBlock.registerUniversalCable("infinite", CableTier.ULTIMATE);
        ABSOLUTE_MECHANICAL_PIPE = ExtraBlock.registerMechanicalPipe("absolute", PipeTier.BASIC);
        SUPREME_MECHANICAL_PIPE = ExtraBlock.registerMechanicalPipe("supreme", PipeTier.ADVANCED);
        COSMIC_MECHANICAL_PIPE = ExtraBlock.registerMechanicalPipe("cosmic", PipeTier.ELITE);
        INFINITE_MECHANICAL_PIPE = ExtraBlock.registerMechanicalPipe("infinite", PipeTier.ULTIMATE);
        ABSOLUTE_PRESSURIZED_TUBE = ExtraBlock.registerPressurizedTube("absolute", TubeTier.BASIC);
        SUPREME_PRESSURIZED_TUBE = ExtraBlock.registerPressurizedTube("supreme", TubeTier.ADVANCED);
        COSMIC_PRESSURIZED_TUBE = ExtraBlock.registerPressurizedTube("cosmic", TubeTier.ELITE);
        INFINITE_PRESSURIZED_TUBE = ExtraBlock.registerPressurizedTube("infinite", TubeTier.ULTIMATE);
        ABSOLUTE_LOGISTICAL_TRANSPORTER = ExtraBlock.registerLogisticalTransporter("absolute", TransporterTier.BASIC);
        SUPREME_LOGISTICAL_TRANSPORTER = ExtraBlock.registerLogisticalTransporter("supreme", TransporterTier.ADVANCED);
        COSMIC_LOGISTICAL_TRANSPORTER = ExtraBlock.registerLogisticalTransporter("cosmic", TransporterTier.ELITE);
        INFINITE_LOGISTICAL_TRANSPORTER = ExtraBlock.registerLogisticalTransporter("infinite", TransporterTier.ULTIMATE);
        ABSOLUTE_THERMODYNAMIC_CONDUCTOR = ExtraBlock.registerThermodynamicConductor("absolute", ConductorTier.BASIC);
        SUPREME_THERMODYNAMIC_CONDUCTOR = ExtraBlock.registerThermodynamicConductor("supreme", ConductorTier.ADVANCED);
        COSMIC_THERMODYNAMIC_CONDUCTOR = ExtraBlock.registerThermodynamicConductor("cosmic", ConductorTier.ELITE);
        INFINITE_THERMODYNAMIC_CONDUCTOR = ExtraBlock.registerThermodynamicConductor("infinite", ConductorTier.ULTIMATE);
        ABSOLUTE_CHEMICAL_TANK = ExtraBlock.registerChemicalTank("absolute", ExtraBlockType.ABSOLUTE_CHEMICAL_TANK);
        SUPREME_CHEMICAL_TANK = ExtraBlock.registerChemicalTank("supreme", ExtraBlockType.SUPREME_CHEMICAL_TANK);
        COSMIC_CHEMICAL_TANK = ExtraBlock.registerChemicalTank("cosmic", ExtraBlockType.COSMIC_CHEMICAL_TANK);
        INFINITE_CHEMICAL_TANK = ExtraBlock.registerChemicalTank("infinite", ExtraBlockType.INFINITE_CHEMICAL_TANK);
        EXPAND_RADIOACTIVE_WASTE_BARREL = EXTRA_BLOCK.registerDefaultProperties("expand_radioactive_waste_barrel", ExtraBlockRadioactiveWasteBarrel::new, ExtraItemBlockRadioactiveWasteBarrel::new);
        ADVANCED_ELECTRIC_PUMP = EXTRA_BLOCK.register("advance_electric_pump", () -> new BlockTile.BlockTileModel(ExtraBlockType.ADVANCED_ELECTRIC_PUMP, properties -> properties.m_284180_(BlockResourceInfo.STEEL.getMapColor())), ItemBlockMachine::new);
    }
}

