/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.item.block.machine;

import com.jerry.mekanism_extras.client.render.ExtraRenderPropertiesProvider;
import com.jerry.mekanism_extras.common.block.attribute.ExtraAttribute;
import com.jerry.mekanism_extras.common.block.basic.ExtraBlockFluidTank;
import com.jerry.mekanism_extras.common.capabilities.fluid.item.ExtraRateLimitFluidHandler;
import com.jerry.mekanism_extras.common.item.block.machine.ExtraItemBlockMachine;
import com.jerry.mekanism_extras.common.tier.FTTier;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.RegistryUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraItemBlockFluidTank
extends ExtraItemBlockMachine
implements IModeItem {
    public ExtraItemBlockFluidTank(ExtraBlockFluidTank block) {
        super((BlockTile<?, ?>)block);
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ExtraRenderPropertiesProvider.extraFluidTank());
    }

    @Override
    @NotNull
    public FTTier getAdvanceTier() {
        return Objects.requireNonNull(ExtraAttribute.getTier(this.m_40614_(), FTTier.class));
    }

    @Override
    protected void addStats(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        FTTier tier = this.getAdvanceTier();
        FluidStack fluidStack = StorageUtils.getStoredFluidFromNBT((ItemStack)stack);
        if (fluidStack.isEmpty()) {
            tooltip.add((Component)MekanismLang.EMPTY.translateColored(EnumColor.DARK_RED, new Object[0]));
        } else {
            tooltip.add((Component)MekanismLang.GENERIC_STORED_MB.translateColored(EnumColor.PINK, new Object[]{fluidStack, EnumColor.GRAY, TextUtils.format((long)fluidStack.getAmount())}));
        }
        tooltip.add((Component)MekanismLang.CAPACITY_MB.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, TextUtils.format((long)tier.getStorage())}));
    }

    @Override
    protected void addTypeDetails(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)MekanismLang.BUCKET_MODE.translateColored(EnumColor.INDIGO, new Object[]{BooleanStateDisplay.YesNo.of((boolean)this.getBucketMode(stack))}));
        super.addTypeDetails(stack, world, tooltip, flag);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        return context.m_43723_() == null || this.getBucketMode(context.m_43722_()) ? InteractionResult.PASS : super.m_6225_(context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.getBucketMode(stack)) {
            if (SecurityUtils.get().tryClaimItem(world, player, stack)) {
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
            }
            if (!ISecurityUtils.INSTANCE.canAccessOrDisplayError(player, (ICapabilityProvider)stack)) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (stack.m_41613_() > 1) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            BlockHitResult result = ExtraItemBlockFluidTank.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)(player.m_6144_() ? ClipContext.Fluid.NONE : ClipContext.Fluid.SOURCE_ONLY));
            if (result.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos pos = result.m_82425_();
                if (!world.m_7966_(player, pos)) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                IExtendedFluidTank fluidTank = ExtraItemBlockFluidTank.getExtendedFluidTank(stack);
                if (fluidTank == null) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                if (!player.m_6144_()) {
                    if (!player.m_36204_(pos, result.m_82434_(), stack)) {
                        return InteractionResultHolder.m_19100_((Object)stack);
                    }
                    BlockState blockState = world.m_8055_(pos);
                    FluidState fluidState = blockState.m_60819_();
                    Optional sound = Optional.empty();
                    if (!fluidState.m_76178_() && fluidState.m_76170_()) {
                        Fluid fluid = fluidState.m_76152_();
                        FluidStack fluidStack = new FluidStack(fluid, 1000);
                        Block block = blockState.m_60734_();
                        if (block instanceof IFluidBlock) {
                            IFluidBlock fluidBlock = (IFluidBlock)block;
                            fluidStack = fluidBlock.drain(world, pos, IFluidHandler.FluidAction.SIMULATE);
                            if (!ExtraItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                                return InteractionResultHolder.m_19098_((Object)stack);
                            }
                            fluidStack = fluidBlock.drain(world, pos, IFluidHandler.FluidAction.EXECUTE);
                        } else if (block instanceof BucketPickup) {
                            BucketPickup bucketPickup = (BucketPickup)block;
                            if (ExtraItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                                BucketItem bucket;
                                ItemStack pickedUpStack = bucketPickup.m_142598_((LevelAccessor)world, pos, blockState);
                                if (pickedUpStack.m_41619_()) {
                                    return InteractionResultHolder.m_19098_((Object)stack);
                                }
                                Item item = pickedUpStack.m_41720_();
                                if (item instanceof BucketItem && !ExtraItemBlockFluidTank.validFluid(fluidTank, fluidStack = new FluidStack(fluid = (bucket = (BucketItem)item).getFluid(), 1000))) {
                                    Mekanism.logger.warn("Fluid removed without successfully picking up. Fluid {} at {} in {} was valid, but after picking up was {}.", new Object[]{RegistryUtils.getName((Fluid)fluidState.m_76152_()), pos, world.m_46472_().m_135782_(), RegistryUtils.getName((Fluid)fluid)});
                                    return InteractionResultHolder.m_19100_((Object)stack);
                                }
                                sound = bucketPickup.getPickupSound(blockState);
                            }
                        }
                        if (ExtraItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                            this.uncheckedGrow(fluidTank, fluidStack);
                            WorldUtils.playFillSound((Player)player, (LevelAccessor)world, (BlockPos)pos, (FluidStack)fluidStack, (SoundEvent)sound.orElse(null));
                            world.m_142346_((Entity)player, GameEvent.f_157816_, pos);
                            return InteractionResultHolder.m_19090_((Object)stack);
                        }
                        return InteractionResultHolder.m_19100_((Object)stack);
                    }
                } else {
                    if (fluidTank.extract(1000, Action.SIMULATE, AutomationType.MANUAL).getAmount() < 1000 || !player.m_36204_(pos.m_121945_(result.m_82434_()), result.m_82434_(), stack)) {
                        return InteractionResultHolder.m_19100_((Object)stack);
                    }
                    if (WorldUtils.tryPlaceContainedLiquid((Player)player, (Level)world, (BlockPos)pos, (FluidStack)fluidTank.getFluid(), (Direction)result.m_82434_())) {
                        if (!player.m_7500_()) {
                            MekanismUtils.logMismatchedStackSize((long)fluidTank.shrinkStack(1000, Action.EXECUTE), (long)1000L);
                        }
                        world.m_142346_((Entity)player, GameEvent.f_157769_, pos);
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private void uncheckedGrow(IExtendedFluidTank fluidTank, FluidStack fluidStack) {
        if (fluidTank.isEmpty()) {
            fluidTank.setStack(fluidStack);
        } else {
            MekanismUtils.logMismatchedStackSize((long)fluidTank.growStack(fluidStack.getAmount(), Action.EXECUTE), (long)fluidStack.getAmount());
        }
    }

    private static boolean validFluid(@NotNull IExtendedFluidTank fluidTank, @NotNull FluidStack fluidStack) {
        return !fluidStack.isEmpty() && fluidTank.insert(fluidStack, Action.SIMULATE, AutomationType.MANUAL).isEmpty();
    }

    private static IExtendedFluidTank getExtendedFluidTank(@NotNull ItemStack stack) {
        IFluidHandlerItem fluidHandlerItem;
        Optional capability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (capability.isPresent() && (fluidHandlerItem = (IFluidHandlerItem)capability.get()) instanceof IMekanismFluidHandler) {
            IMekanismFluidHandler fluidHandler = (IMekanismFluidHandler)fluidHandlerItem;
            return fluidHandler.getFluidTank(0, null);
        }
        return null;
    }

    public void setBucketMode(ItemStack itemStack, boolean bucketMode) {
        ItemDataUtils.setBoolean((ItemStack)itemStack, (String)"bucketMode", (boolean)bucketMode);
    }

    public boolean getBucketMode(ItemStack itemStack) {
        return ItemDataUtils.getBoolean((ItemStack)itemStack, (String)"bucketMode");
    }

    @Override
    protected void gatherCapabilities(List<ItemCapabilityWrapper.ItemCapability> capabilities, ItemStack stack, CompoundTag nbt) {
        super.gatherCapabilities(capabilities, stack, nbt);
        capabilities.add((ItemCapabilityWrapper.ItemCapability)ExtraRateLimitFluidHandler.create(this.getAdvanceTier()));
    }

    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        if (Math.abs(shift) % 2 == 1) {
            boolean newState = !this.getBucketMode(stack);
            this.setBucketMode(stack, newState);
            displayChange.sendMessage(player, () -> MekanismLang.BUCKET_MODE.translate(new Object[]{BooleanStateDisplay.OnOff.of((boolean)newState, (boolean)true)}));
        }
    }

    @NotNull
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return MekanismLang.BUCKET_MODE.translateColored(EnumColor.GRAY, new Object[]{BooleanStateDisplay.OnOff.of((boolean)this.getBucketMode(stack), (boolean)true)});
    }

    public static class BasicDrainCauldronInteraction
    extends BasicCauldronInteraction {
        public static final BasicDrainCauldronInteraction WATER = new BasicDrainCauldronInteraction((Fluid)Fluids.f_76193_){

            @Override
            @NotNull
            protected InteractionResult interact(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack stack, @NotNull IExtendedFluidTank fluidTank) {
                if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3) {
                    return super.interact(state, level, pos, player, hand, stack, fluidTank);
                }
                return InteractionResult.PASS;
            }
        };
        public static final BasicDrainCauldronInteraction LAVA = new BasicDrainCauldronInteraction((Fluid)Fluids.f_76195_);
        private final Fluid type;

        private BasicDrainCauldronInteraction(Fluid type) {
            this.type = type;
        }

        @Override
        @NotNull
        protected InteractionResult interact(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack stack, @NotNull IExtendedFluidTank fluidTank) {
            FluidStack fluidStack = new FluidStack(this.type, 1000);
            FluidStack remainder = fluidTank.insert(fluidStack, Action.SIMULATE, AutomationType.MANUAL);
            if (remainder.isEmpty()) {
                if (!level.f_46443_) {
                    if (!player.m_7500_()) {
                        ((ExtraItemBlockFluidTank)stack.m_41720_()).uncheckedGrow(fluidTank, fluidStack);
                    }
                    player.m_36220_(Stats.f_12944_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                    level.m_46597_(pos, Blocks.f_50256_.m_49966_());
                    SoundEvent fillSound = fluidStack.getFluid().getFluidType().getSound(null, (BlockGetter)level, pos, SoundActions.BUCKET_FILL);
                    if (fillSound != null) {
                        level.m_5594_(null, pos, fillSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    level.m_142346_(null, GameEvent.f_157816_, pos);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }
    }

    public static abstract class BasicCauldronInteraction
    implements CauldronInteraction {
        public static final BasicCauldronInteraction EMPTY = new BasicCauldronInteraction(){

            @Nullable
            private BlockState getState(FluidStack current) {
                Fluid type = current.getFluid();
                if (type == Fluids.f_76193_) {
                    return (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
                }
                if (type == Fluids.f_76195_) {
                    return Blocks.f_152477_.m_49966_();
                }
                return null;
            }

            @Override
            @NotNull
            protected InteractionResult interact(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack stack, @NotNull IExtendedFluidTank fluidTank) {
                FluidStack fluidStack = fluidTank.getFluid();
                BlockState endState = this.getState(fluidStack);
                if (endState != null && fluidTank.extract(1000, Action.SIMULATE, AutomationType.MANUAL).getAmount() >= 1000) {
                    if (!level.f_46443_) {
                        if (!player.m_7500_()) {
                            MekanismUtils.logMismatchedStackSize((long)fluidTank.shrinkStack(1000, Action.EXECUTE), (long)1000L);
                        }
                        player.m_36220_(Stats.f_12943_);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                        level.m_46597_(pos, endState);
                        SoundEvent emptySound = fluidStack.getFluid().getFluidType().getSound(player, (BlockGetter)level, pos, SoundActions.BUCKET_EMPTY);
                        if (emptySound != null) {
                            level.m_5594_(null, pos, emptySound, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        level.m_142346_(null, GameEvent.f_157769_, pos);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                return InteractionResult.PASS;
            }
        };

        @NotNull
        public final InteractionResult m_175710_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack stack) {
            ExtraItemBlockFluidTank tank;
            Item item;
            if (stack.m_41613_() == 1 && (item = stack.m_41720_()) instanceof ExtraItemBlockFluidTank && (tank = (ExtraItemBlockFluidTank)item).getBucketMode(stack)) {
                IExtendedFluidTank fluidTank = ExtraItemBlockFluidTank.getExtendedFluidTank(stack);
                if (fluidTank == null) {
                    return InteractionResult.PASS;
                }
                return this.interact(state, level, pos, player, hand, stack, fluidTank);
            }
            return InteractionResult.PASS;
        }

        @NotNull
        protected abstract InteractionResult interact(@NotNull BlockState var1, @NotNull Level var2, @NotNull BlockPos var3, @NotNull Player var4, @NotNull InteractionHand var5, @NotNull ItemStack var6, @NotNull IExtendedFluidTank var7);
    }

    public static class FluidTankItemDispenseBehavior
    extends DefaultDispenseItemBehavior {
        public static final FluidTankItemDispenseBehavior INSTANCE = new FluidTankItemDispenseBehavior();

        private FluidTankItemDispenseBehavior() {
        }

        @NotNull
        public ItemStack m_7498_(@NotNull BlockSource source, @NotNull ItemStack stack) {
            ExtraItemBlockFluidTank tank;
            Item item;
            if (stack.m_41613_() == 1 && (item = stack.m_41720_()) instanceof ExtraItemBlockFluidTank && (tank = (ExtraItemBlockFluidTank)item).getBucketMode(stack)) {
                IExtendedFluidTank fluidTank = ExtraItemBlockFluidTank.getExtendedFluidTank(stack);
                if (fluidTank == null) {
                    return super.m_7498_(source, stack);
                }
                ServerLevel world = source.m_7727_();
                BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                BlockState blockState = world.m_8055_(pos);
                FluidState fluidState = blockState.m_60819_();
                Optional sound = Optional.empty();
                if (!fluidState.m_76178_() && fluidState.m_76170_()) {
                    Fluid fluid = fluidState.m_76152_();
                    FluidStack fluidStack = new FluidStack(fluid, 1000);
                    Block block = blockState.m_60734_();
                    if (block instanceof IFluidBlock) {
                        IFluidBlock fluidBlock = (IFluidBlock)block;
                        fluidStack = fluidBlock.drain((Level)world, pos, IFluidHandler.FluidAction.SIMULATE);
                        if (!ExtraItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                            return super.m_7498_(source, stack);
                        }
                        fluidStack = fluidBlock.drain((Level)world, pos, IFluidHandler.FluidAction.EXECUTE);
                    } else if (block instanceof BucketPickup) {
                        BucketPickup bucketPickup = (BucketPickup)block;
                        if (ExtraItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                            BucketItem bucket;
                            ItemStack pickedUpStack = bucketPickup.m_142598_((LevelAccessor)world, pos, blockState);
                            if (pickedUpStack.m_41619_()) {
                                return super.m_7498_(source, stack);
                            }
                            Item item2 = pickedUpStack.m_41720_();
                            if (item2 instanceof BucketItem && !ExtraItemBlockFluidTank.validFluid(fluidTank, fluidStack = new FluidStack(fluid = (bucket = (BucketItem)item2).getFluid(), 1000))) {
                                Mekanism.logger.warn("Fluid removed without successfully picking up. Fluid {} at {} in {} was valid, but after picking up was {}.", new Object[]{RegistryUtils.getName((Fluid)fluidState.m_76152_()), pos, world.m_46472_().m_135782_(), RegistryUtils.getName((Fluid)fluid)});
                                return super.m_7498_(source, stack);
                            }
                            sound = bucketPickup.getPickupSound(blockState);
                        }
                    }
                    if (ExtraItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                        tank.uncheckedGrow(fluidTank, fluidStack);
                        WorldUtils.playFillSound(null, (LevelAccessor)world, (BlockPos)pos, (FluidStack)fluidStack, (SoundEvent)sound.orElse(null));
                        world.m_142346_(null, GameEvent.f_157816_, pos);
                        return stack;
                    }
                } else if (fluidTank.extract(1000, Action.SIMULATE, AutomationType.MANUAL).getAmount() >= 1000 && WorldUtils.tryPlaceContainedLiquid(null, (Level)world, (BlockPos)pos, (FluidStack)fluidTank.getFluid(), null)) {
                    MekanismUtils.logMismatchedStackSize((long)fluidTank.shrinkStack(1000, Action.EXECUTE), (long)1000L);
                    world.m_142346_(null, GameEvent.f_157769_, pos);
                    return stack;
                }
            }
            return super.m_7498_(source, stack);
        }
    }
}

