/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.item.block;

import com.jerry.mekanism_extras.client.render.ExtraRenderPropertiesProvider;
import com.jerry.mekanism_extras.common.block.ExtraBlockEnergyCube;
import com.jerry.mekanism_extras.common.block.attribute.ExtraAttribute;
import com.jerry.mekanism_extras.common.capabilities.energy.item.ExtraRateLimitEnergyHandler;
import com.jerry.mekanism_extras.common.item.block.ExtraItemBlockTooltip;
import com.jerry.mekanism_extras.common.tier.ECTier;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mekanism.api.RelativeSide;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.item.ItemStackEnergyHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class ExtraItemBlockEnergyCube
extends ExtraItemBlockTooltip<ExtraBlockEnergyCube>
implements IItemSustainedInventory,
CreativeTabDeferredRegister.ICustomCreativeTabContents {
    public ExtraItemBlockEnergyCube(ExtraBlockEnergyCube block) {
        super(block);
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ExtraRenderPropertiesProvider.extraEnergyCube());
    }

    @Override
    @Nonnull
    public ECTier getAdvanceTier() {
        return Objects.requireNonNull(ExtraAttribute.getTier(this.m_40614_(), ECTier.class));
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        StorageUtils.addStoredEnergy((ItemStack)stack, tooltip, (boolean)true);
        tooltip.add((Component)MekanismLang.CAPACITY.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, EnergyDisplay.of((FloatingLong)this.getAdvanceTier().getMaxEnergy())}));
        super.m_7373_(stack, world, tooltip, flag);
    }

    @Override
    protected void addTypeDetails(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth((ItemStack)stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    public void addItems(CreativeModeTab.Output tabOutput) {
        tabOutput.m_246342_(StorageUtils.getFilledEnergyVariant((ItemStack)new ItemStack((ItemLike)this), (FloatingLong)this.getAdvanceTier().getMaxEnergy()));
    }

    public boolean addDefault() {
        return true;
    }

    private ItemStack withEnergyCubeSideConfig(DataType dataType) {
        CompoundTag sideConfig = new CompoundTag();
        for (RelativeSide side : EnumUtils.SIDES) {
            NBTUtils.writeEnum((CompoundTag)sideConfig, (String)("side" + side.ordinal()), (Enum)dataType);
        }
        CompoundTag configNBT = new CompoundTag();
        configNBT.m_128365_("config" + TransmissionType.ENERGY.ordinal(), (Tag)sideConfig);
        ItemStack stack = new ItemStack((ItemLike)this);
        ItemDataUtils.setCompound((ItemStack)stack, (String)"componentConfig", (CompoundTag)configNBT);
        return stack;
    }

    @Override
    protected void gatherCapabilities(List<ItemCapabilityWrapper.ItemCapability> capabilities, ItemStack stack, CompoundTag nbt) {
        super.gatherCapabilities(capabilities, stack, nbt);
        ExtraRateLimitEnergyHandler capability = ExtraRateLimitEnergyHandler.create(this.getAdvanceTier());
        int index = IntStream.range(0, capabilities.size()).filter(i -> capabilities.get(i) instanceof ItemStackEnergyHandler).findFirst().orElse(-1);
        if (index != -1) {
            capabilities.set(index, (ItemCapabilityWrapper.ItemCapability)capability);
        } else {
            capabilities.add((ItemCapabilityWrapper.ItemCapability)capability);
        }
    }
}

