/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.item.block;

import com.jerry.mekanism_extras.common.block.attribute.ExtraAttribute;
import com.jerry.mekanism_extras.common.block.basic.ExtraBlockBin;
import com.jerry.mekanism_extras.common.inventory.ExtraBinMekanismInventory;
import com.jerry.mekanism_extras.common.inventory.slot.ExtraBinInventorySlot;
import com.jerry.mekanism_extras.common.item.block.ExtraItemBlockTooltip;
import com.jerry.mekanism_extras.common.tier.BTier;
import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ExtraItemBlockBin
extends ExtraItemBlockTooltip<ExtraBlockBin>
implements IItemSustainedInventory {
    public ExtraItemBlockBin(ExtraBlockBin block) {
        super(block, new Item.Properties().m_41487_(1));
    }

    @Override
    public BTier getAdvanceTier() {
        return ExtraAttribute.getTier(this.m_40614_(), BTier.class);
    }

    @Override
    protected void addStats(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        ExtraBinMekanismInventory inventory = ExtraBinMekanismInventory.create(stack);
        BTier tier = this.getAdvanceTier();
        if (inventory != null && tier != null) {
            ExtraBinInventorySlot slot = inventory.getBinSlot();
            if (slot.isEmpty()) {
                tooltip.add((Component)MekanismLang.EMPTY.translateColored(EnumColor.DARK_RED, new Object[0]));
            } else {
                tooltip.add((Component)MekanismLang.STORING.translateColored(EnumColor.BRIGHT_GREEN, new Object[]{EnumColor.GRAY, slot.getStack()}));
                tooltip.add((Component)MekanismLang.ITEM_AMOUNT.translateColored(EnumColor.PURPLE, new Object[]{EnumColor.GRAY, TextUtils.format((long)slot.getCount())}));
            }
            if (slot.isLocked()) {
                tooltip.add((Component)MekanismLang.LOCKED.translateColored(EnumColor.AQUA, new Object[]{EnumColor.GRAY, slot.getLockStack()}));
            }
            tooltip.add((Component)MekanismLang.CAPACITY_ITEMS.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, TextUtils.format((long)tier.getStorage())}));
        }
    }

    public boolean canContentsDrop(ItemStack stack) {
        return true;
    }
}

