/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.content.blocktype;

import com.jerry.mekanism_extras.common.block.attribute.ExtraAttributeTier;
import com.jerry.mekanism_extras.common.block.attribute.ExtraAttributeUpgradeable;
import com.jerry.mekanism_extras.common.content.blocktype.AdvancedMachine;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import com.jerry.mekanism_extras.common.registry.ExtraBlockType;
import com.jerry.mekanism_extras.common.registry.ExtraContainerTypes;
import com.jerry.mekanism_extras.common.tier.AdvancedFactoryTier;
import com.jerry.mekanism_extras.common.tile.factory.TileEntityExtraFactory;
import com.jerry.mekanism_extras.common.util.ExtraEnumUtils;
import java.util.function.Supplier;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.AttributeSound;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.content.blocktype.BlockShapes;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import org.jetbrains.annotations.NotNull;

public class AdvancedFactory<TILE extends TileEntityExtraFactory<?>>
extends AdvancedMachine.AdvancedFactoryMachine<TILE> {
    private final AdvancedMachine.AdvancedFactoryMachine<?> origMachine;

    public AdvancedFactory(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, Supplier<ContainerTypeRegistryObject<? extends MekanismContainer>> containerRegistrar, AdvancedMachine.AdvancedFactoryMachine<?> origMachine, AdvancedFactoryTier tier) {
        super(tileEntityRegistrar, MekanismLang.DESCRIPTION_FACTORY, origMachine.getFactoryType());
        this.origMachine = origMachine;
        this.setMachineData(tier);
        this.add(new Attribute[]{new AttributeGui(containerRegistrar, null), new ExtraAttributeTier<AdvancedFactoryTier>(tier)});
        if (tier.ordinal() < ExtraEnumUtils.ADVANCED_FACTORY_TIERS.length - 1) {
            this.add(new Attribute[]{new ExtraAttributeUpgradeable(() -> ExtraBlock.getAdvancedFactory(ExtraEnumUtils.ADVANCED_FACTORY_TIERS[tier.ordinal() + 1], origMachine.getFactoryType()))});
        }
    }

    private void setMachineData(AdvancedFactoryTier tier) {
        this.setFrom((BlockTypeTile)this.origMachine, new Class[]{AttributeSound.class, AttributeFactoryType.class, AttributeUpgradeSupport.class});
        AttributeEnergy origEnergy = (AttributeEnergy)this.origMachine.get(AttributeEnergy.class);
        if (origEnergy != null) {
            Attribute[] attributeArray = new Attribute[1];
            attributeArray[0] = new AttributeEnergy(() -> ((AttributeEnergy)origEnergy).getUsage(), () -> origEnergy.getConfigStorage().multiply(0.5).max(origEnergy.getUsage()).multiply((long)tier.processes));
            this.add(attributeArray);
        }
    }

    @NotNull
    private static <TILE extends TileEntityExtraFactory<?>> AdvancedFactoryBuilder<AdvancedFactory<TILE>, TILE, ?> getAdvancedFactoryTILEAdvancedFactoryBuilder(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, FactoryType type, AdvancedFactoryTier tier) {
        Supplier<ContainerTypeRegistryObject<? extends MekanismContainer>> supplier = () -> ExtraContainerTypes.FACTORY;
        AdvancedFactoryBuilder builder = new AdvancedFactoryBuilder(new AdvancedFactory<TILE>(tileEntityRegistrar, supplier, switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FactoryType.SAWING -> ExtraBlockType.PRECISION_SAWMILL;
            case FactoryType.SMELTING -> ExtraBlockType.ENERGIZED_SMELTER;
            case FactoryType.ENRICHING -> ExtraBlockType.ENRICHMENT_CHAMBER;
            case FactoryType.CRUSHING -> ExtraBlockType.CRUSHER;
            case FactoryType.COMPRESSING -> ExtraBlockType.OSMIUM_COMPRESSOR;
            case FactoryType.COMBINING -> ExtraBlockType.COMBINER;
            case FactoryType.PURIFYING -> ExtraBlockType.PURIFICATION_CHAMBER;
            case FactoryType.INJECTING -> ExtraBlockType.CHEMICAL_INJECTION_CHAMBER;
            case FactoryType.INFUSING -> ExtraBlockType.METALLURGIC_INFUSER;
        }, tier));
        builder.withComputerSupport(tier.getAdvanceTier().getLowerName() + type.getRegistryNameComponentCapitalized() + "Factory");
        return builder;
    }

    public static class AdvancedFactoryBuilder<FACTORY extends AdvancedFactory<TILE>, TILE extends TileEntityExtraFactory<?>, T extends AdvancedMachine.AdvancedMachineBuilder<FACTORY, TILE, T>>
    extends BlockTypeTile.BlockTileBuilder<FACTORY, TILE, T> {
        protected AdvancedFactoryBuilder(FACTORY holder) {
            super(holder);
        }

        public static <TILE extends TileEntityExtraFactory<?>> AdvancedFactoryBuilder<AdvancedFactory<TILE>, TILE, ?> createFactory(Supplier<?> tileEntityRegistrar, FactoryType type, AdvancedFactoryTier tier) {
            AdvancedFactoryBuilder builder = AdvancedFactory.getAdvancedFactoryTILEAdvancedFactoryBuilder(tileEntityRegistrar, type, tier);
            builder.withCustomShape(BlockShapes.getShape(null, (FactoryType)type));
            builder.replace(new Attribute[]{new AttributeParticleFX().addDense((ParticleOptions)ParticleTypes.f_123762_, 5, rand -> new Pos3D((double)(rand.m_188501_() * 0.7f - 0.3f), (double)(rand.m_188501_() * 0.1f + 0.7f), (double)(rand.m_188501_() * 0.7f - 0.3f)))});
            return builder;
        }
    }
}

