/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.client.gui.element.button;

import com.jerry.mekanism_extras.common.tile.ExtraTileEntityChemicalTank;
import java.util.function.Supplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.common.Mekanism;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ExtraGuiGasMode
extends MekanismImageButton {
    private static final ResourceLocation IDLE = MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"gas_mode_idle.png");
    private static final ResourceLocation EXCESS = MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"gas_mode_excess.png");
    private static final ResourceLocation DUMP = MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"gas_mode_dump.png");
    private final boolean left;
    private final Supplier<ExtraTileEntityChemicalTank.GasMode> gasModeSupplier;

    public ExtraGuiGasMode(IGuiWrapper gui, int x, int y, boolean left, Supplier<ExtraTileEntityChemicalTank.GasMode> gasModeSupplier, BlockPos pos, int tank) {
        this(gui, x, y, left, gasModeSupplier, pos, tank, null);
    }

    public ExtraGuiGasMode(IGuiWrapper gui, int x, int y, boolean left, Supplier<ExtraTileEntityChemicalTank.GasMode> gasModeSupplier, BlockPos pos, int tank, GuiElement.IHoverable onHover) {
        super(gui, x, y, 10, IDLE, () -> Mekanism.packetHandler().sendToServer((Object)new PacketGuiInteract(PacketGuiInteract.GuiInteraction.GAS_MODE_BUTTON, pos, tank)), onHover);
        this.left = left;
        this.gasModeSupplier = gasModeSupplier;
    }

    protected ResourceLocation getResource() {
        return switch (this.gasModeSupplier.get()) {
            case ExtraTileEntityChemicalTank.GasMode.DUMPING_EXCESS -> EXCESS;
            case ExtraTileEntityChemicalTank.GasMode.DUMPING -> DUMP;
            default -> super.getResource();
        };
    }

    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Component component = this.gasModeSupplier.get().getTextComponent();
        if (this.left) {
            this.drawTextScaledBound(guiGraphics, component, this.relativeX - 3 - (int)((float)this.getStringWidth(component) * this.getNeededScale(component, 66.0f)), this.relativeY + 1, this.titleTextColor(), 66.0f);
        } else {
            this.drawTextScaledBound(guiGraphics, component, this.relativeX + this.f_93618_ + 5, this.relativeY + 1, this.titleTextColor(), 66.0f);
        }
        super.renderForeground(guiGraphics, mouseX, mouseY);
    }
}

