/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.api.tier;

import java.util.Locale;
import mekanism.api.SupportsColorMap;
import mekanism.api.math.MathUtils;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public enum AdvancedTier implements StringRepresentable,
SupportsColorMap
{
    ABSOLUTE("Absolute", new int[]{95, 255, 184}, MapColor.f_283916_),
    SUPREME("Supreme", new int[]{255, 128, 106}, MapColor.f_283870_),
    COSMIC("Cosmic", new int[]{75, 248, 255}, MapColor.f_283821_),
    INFINITE("Infinite", new int[]{247, 135, 255}, MapColor.f_283931_);

    private static final AdvancedTier[] TIERS;
    private final String name;
    private final MapColor mapColor;
    private TextColor textColor;
    private int[] rgbCode;

    private AdvancedTier(String name, int[] rgbCode, MapColor mapColor) {
        this.name = name;
        this.mapColor = mapColor;
        this.setColorFromAtlas(rgbCode);
    }

    public String getSimpleName() {
        return this.name;
    }

    public String getLowerName() {
        return this.getSimpleName().toLowerCase(Locale.ROOT);
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public int[] getRgbCode() {
        return this.rgbCode;
    }

    public void setColorFromAtlas(int[] color) {
        this.rgbCode = color;
        this.textColor = TextColor.m_131266_((int)(this.rgbCode[0] << 16 | this.rgbCode[1] << 8 | this.rgbCode[2]));
    }

    public TextColor getColor() {
        return this.textColor;
    }

    @NotNull
    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static AdvancedTier byIndexStatic(int index) {
        return (AdvancedTier)((Object)MathUtils.getByIndexMod((Object[])TIERS, (int)index));
    }

    static {
        TIERS = AdvancedTier.values();
    }
}

