/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.generator_extras.common.tile.reactor;

import com.jerry.generator_extras.common.content.reactor.NaquadahReactorMultiblockData;
import com.jerry.generator_extras.common.genregistry.ExtraGenBlocks;
import com.jerry.generator_extras.common.tile.reactor.TileEntityNaquadahReactorCasing;
import java.util.EnumSet;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.base.IReactorLogicMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class TileEntityNaquadahReactorLogicAdapter
extends TileEntityNaquadahReactorCasing
implements IReactorLogic<NaquadahReactorLogic>,
IHasMode {
    public NaquadahReactorLogic logicType = NaquadahReactorLogic.DISABLED;
    private boolean activeCooled;
    private boolean prevOutputting;

    public TileEntityNaquadahReactorLogicAdapter(BlockPos pos, BlockState state) {
        super((IBlockProvider)ExtraGenBlocks.NAQUADAH_REACTOR_LOGIC_ADAPTER, pos, state);
    }

    protected boolean onUpdateServer(NaquadahReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        boolean outputting = this.checkMode();
        if (outputting != this.prevOutputting) {
            Level world = this.m_58904_();
            if (world != null) {
                Direction side = multiblock.getOutsideSide(this.f_58858_);
                if (side == null) {
                    world.m_46672_(this.m_58899_(), this.getBlockType());
                } else if (!ForgeEventFactory.onNeighborNotify((Level)world, (BlockPos)this.f_58858_, (BlockState)this.m_58900_(), EnumSet.of(side), (boolean)false).isCanceled()) {
                    world.m_46586_(this.f_58858_.m_121945_(side), this.getBlockType(), this.f_58858_);
                }
            }
            this.prevOutputting = outputting;
        }
        return needsPacket;
    }

    public int getRedstoneLevel(Direction side) {
        return !this.isRemote() && ((NaquadahReactorMultiblockData)this.getMultiblock()).isPositionOutsideBounds(this.f_58858_.m_121945_(side)) && this.checkMode() ? 15 : 0;
    }

    public boolean checkMode() {
        if (this.isRemote()) {
            return this.prevOutputting;
        }
        NaquadahReactorMultiblockData multiblock = (NaquadahReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            return switch (this.logicType) {
                default -> throw new IncompatibleClassChangeError();
                case NaquadahReactorLogic.READY -> {
                    if (multiblock.getLastPlasmaTemp() >= multiblock.getIgnitionTemperature(this.activeCooled)) {
                        yield true;
                    }
                    yield false;
                }
                case NaquadahReactorLogic.CAPACITY -> {
                    if (multiblock.getLastPlasmaTemp() >= multiblock.getMaxPlasmaTemperature(this.activeCooled)) {
                        yield true;
                    }
                    yield false;
                }
                case NaquadahReactorLogic.DEPLETED -> {
                    if (multiblock.fuelTank.isEmpty()) {
                        int injectionPortion = multiblock.getInjectionRate() / 2;
                        if (injectionPortion == 0 || multiblock.naquadahTank.getStored() < (long)injectionPortion || multiblock.uraniumTank.getStored() < (long)injectionPortion) {
                            yield true;
                        }
                        yield false;
                    }
                    yield false;
                }
                case NaquadahReactorLogic.DISABLED -> false;
            };
        }
        return false;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        NBTUtils.setEnumIfPresent((CompoundTag)nbt, (String)"logicType", NaquadahReactorLogic::byIndexStatic, logicType -> {
            this.logicType = logicType;
        });
        this.activeCooled = nbt.m_128471_("activeCooled");
    }

    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        NBTUtils.writeEnum((CompoundTag)nbtTags, (String)"logicType", (Enum)this.logicType);
        nbtTags.m_128379_("activeCooled", this.activeCooled);
    }

    @Override
    public boolean canBeMaster() {
        return false;
    }

    public void nextMode() {
        this.activeCooled = !this.activeCooled;
        this.markForSave();
    }

    public void previousMode() {
        this.nextMode();
    }

    @ComputerMethod(nameOverride="isActiveCooledLogic")
    public boolean isActiveCooled() {
        return this.activeCooled;
    }

    @ComputerMethod(nameOverride="getLogicMode")
    public NaquadahReactorLogic getMode() {
        return this.logicType;
    }

    public NaquadahReactorLogic[] getModes() {
        return NaquadahReactorLogic.values();
    }

    @ComputerMethod(nameOverride="setLogicMode")
    public void setLogicTypeFromPacket(NaquadahReactorLogic logicType) {
        if (this.logicType != logicType) {
            this.logicType = logicType;
            this.markForSave();
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create(NaquadahReactorLogic::byIndexStatic, (Enum)NaquadahReactorLogic.DISABLED, this::getMode, value -> {
            this.logicType = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isActiveCooled, value -> {
            this.activeCooled = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(() -> this.prevOutputting, value -> {
            this.prevOutputting = value;
        }));
    }

    @ComputerMethod
    void setActiveCooledLogic(boolean active) {
        if (this.activeCooled != active) {
            this.nextMode();
        }
    }

    @NothingNullByDefault
    public static enum NaquadahReactorLogic implements IReactorLogicMode<NaquadahReactorLogic>,
    IHasTranslationKey
    {
        DISABLED((ILangEntry)GeneratorsLang.REACTOR_LOGIC_DISABLED, (ILangEntry)GeneratorsLang.DESCRIPTION_REACTOR_DISABLED, new ItemStack((ItemLike)Items.f_42403_)),
        READY((ILangEntry)GeneratorsLang.REACTOR_LOGIC_READY, (ILangEntry)GeneratorsLang.DESCRIPTION_REACTOR_READY, new ItemStack((ItemLike)Items.f_42451_)),
        CAPACITY((ILangEntry)GeneratorsLang.REACTOR_LOGIC_CAPACITY, (ILangEntry)GeneratorsLang.DESCRIPTION_REACTOR_CAPACITY, new ItemStack((ItemLike)Items.f_42451_)),
        DEPLETED((ILangEntry)GeneratorsLang.REACTOR_LOGIC_DEPLETED, (ILangEntry)GeneratorsLang.DESCRIPTION_REACTOR_DEPLETED, new ItemStack((ItemLike)Items.f_42451_));

        private static final NaquadahReactorLogic[] MODES;
        private final ILangEntry name;
        private final ILangEntry description;
        private final ItemStack renderStack;

        private NaquadahReactorLogic(ILangEntry name, ILangEntry description, ItemStack stack) {
            this.name = name;
            this.description = description;
            this.renderStack = stack;
        }

        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }

        public Component getDescription() {
            return this.description.translate(new Object[0]);
        }

        public EnumColor getColor() {
            return EnumColor.RED;
        }

        public static NaquadahReactorLogic byIndexStatic(int index) {
            return (NaquadahReactorLogic)((Object)MathUtils.getByIndexMod((Object[])MODES, (int)index));
        }

        static {
            MODES = NaquadahReactorLogic.values();
        }
    }
}

