/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.generator_extras.client.gui;

import com.jerry.generator_extras.client.gui.GuiNaquadahReactorInfo;
import com.jerry.generator_extras.client.gui.element.GuiNaquadahReactorTab;
import com.jerry.generator_extras.common.content.reactor.NaquadahReactorMultiblockData;
import com.jerry.generator_extras.common.tile.reactor.TileEntityNaquadahReactorController;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiNumberGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.generators.common.GeneratorsLang;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class GuiNaquadahReactorHeat
extends GuiNaquadahReactorInfo {
    private static final double MAX_LEVEL = 5.0E8;

    public GuiNaquadahReactorHeat(EmptyTileContainer<TileEntityNaquadahReactorController> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getBaseFluidTexture((Fluid)Fluids.f_76195_, (MekanismRenderer.FluidTextureType)MekanismRenderer.FluidTextureType.STILL);
            }

            public double getLevel() {
                return ((NaquadahReactorMultiblockData)((TileEntityNaquadahReactorController)GuiNaquadahReactorHeat.this.tile).getMultiblock()).getLastPlasmaTemp();
            }

            public double getScaledLevel() {
                return Math.min(1.0, this.getLevel() / 5.0E8);
            }

            public Component getText() {
                return GeneratorsLang.REACTOR_PLASMA.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)this.getLevel(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)});
            }
        }, GaugeType.STANDARD, (IGuiWrapper)this, 7, 50));
        this.addRenderableWidget((GuiElement)new GuiProgress(() -> {
            NaquadahReactorMultiblockData multiblock = (NaquadahReactorMultiblockData)((TileEntityNaquadahReactorController)this.tile).getMultiblock();
            return multiblock.getLastPlasmaTemp() > multiblock.getLastCaseTemp();
        }, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 29, 76));
        this.addRenderableWidget((GuiElement)new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getBaseFluidTexture((Fluid)Fluids.f_76195_, (MekanismRenderer.FluidTextureType)MekanismRenderer.FluidTextureType.STILL);
            }

            public double getLevel() {
                return ((NaquadahReactorMultiblockData)((TileEntityNaquadahReactorController)GuiNaquadahReactorHeat.this.tile).getMultiblock()).getLastCaseTemp();
            }

            public double getScaledLevel() {
                return Math.min(1.0, this.getLevel() / 5.0E8);
            }

            public Component getText() {
                return GeneratorsLang.REACTOR_CASE.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)this.getLevel(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)});
            }
        }, GaugeType.STANDARD, (IGuiWrapper)this, 61, 50));
        this.addRenderableWidget((GuiElement)new GuiProgress(() -> ((NaquadahReactorMultiblockData)((TileEntityNaquadahReactorController)this.tile).getMultiblock()).getCaseTemp() > 0.0, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 83, 61));
        this.addRenderableWidget((GuiElement)new GuiProgress(() -> {
            NaquadahReactorMultiblockData multiblock = (NaquadahReactorMultiblockData)((TileEntityNaquadahReactorController)this.tile).getMultiblock();
            return multiblock.getCaseTemp() > 0.0 && !multiblock.waterTank.isEmpty() && multiblock.steamTank.getStored() < multiblock.steamTank.getCapacity();
        }, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 83, 91));
        this.addRenderableWidget((GuiElement)new GuiFluidGauge(() -> ((NaquadahReactorMultiblockData)((TileEntityNaquadahReactorController)this.tile).getMultiblock()).waterTank, () -> ((TileEntityNaquadahReactorController)this.tile).getFluidTanks(null), GaugeType.SMALL, (IGuiWrapper)this, 115, 84));
        this.addRenderableWidget((GuiElement)new GuiGasGauge(() -> ((NaquadahReactorMultiblockData)((TileEntityNaquadahReactorController)this.tile).getMultiblock()).steamTank, () -> ((TileEntityNaquadahReactorController)this.tile).getGasTanks(null), GaugeType.SMALL, (IGuiWrapper)this, 151, 84));
        this.addRenderableWidget((GuiElement)new GuiEnergyGauge(((NaquadahReactorMultiblockData)((TileEntityNaquadahReactorController)this.tile).getMultiblock()).energyContainer, GaugeType.SMALL, (IGuiWrapper)this, 115, 46));
        this.addRenderableWidget((GuiElement)new GuiNaquadahReactorTab((IGuiWrapper)this, (TileEntityNaquadahReactorController)this.tile, GuiNaquadahReactorTab.NaquadahReactorTab.FUEL));
        this.addRenderableWidget((GuiElement)new GuiNaquadahReactorTab((IGuiWrapper)this, (TileEntityNaquadahReactorController)this.tile, GuiNaquadahReactorTab.NaquadahReactorTab.STAT));
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

