/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.meinfinitycell.common.inventory;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.yxiao233.meinfinitycell.common.items.InfinitiesCell;
import net.yxiao233.meinfinitycell.common.utils.KeyList;
import org.jetbrains.annotations.Nullable;

public class InfinitiesCellInventory
implements StorageCell {
    private final ItemStack stack;
    private final KeyList keys;
    public static final ICellHandler HANDLER = new Handler();

    public InfinitiesCellInventory(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof InfinitiesCell)) {
            throw new IllegalArgumentException("Cell isn't an infinity cell!");
        }
        InfinitiesCell cell = (InfinitiesCell)item;
        this.stack = stack;
        this.keys = cell.getKeys();
    }

    public CellState getStatus() {
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return 1.0;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        return this.keys.insert(what, amount);
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        return this.keys.extract(what, amount);
    }

    public void persist() {
    }

    public Component getDescription() {
        return this.stack.m_41786_();
    }

    public void getAvailableStacks(KeyCounter out) {
        this.keys.getAvailableStacks(out);
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return this.keys.contains(what);
    }

    private static class Handler
    implements ICellHandler {
        private Handler() {
        }

        public boolean isCell(ItemStack is) {
            return is != null && is.m_41720_() instanceof InfinitiesCell;
        }

        @Nullable
        public StorageCell getCellInventory(ItemStack is, @Nullable ISaveProvider host) {
            return this.isCell(is) ? new InfinitiesCellInventory(is) : null;
        }
    }
}

