/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.accessor.ManagedAccessor;
import com.lowdragmc.lowdraglib.syncdata.managed.IManagedVar;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.ObjectTypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.PrimitiveTypedPayload;

public abstract class SimpleObjectAccessor
extends ManagedAccessor {
    private final Class<?>[] operandTypes;

    protected SimpleObjectAccessor(Class<?> ... operandTypes) {
        this.operandTypes = operandTypes;
    }

    @Override
    public Class<?>[] operandTypes() {
        return this.operandTypes;
    }

    public abstract ObjectTypedPayload<?> createEmpty();

    @Override
    public ITypedPayload<?> readManagedField(AccessorOp op, IManagedVar<?> field) {
        Object value = field.value();
        if (value != null) {
            return this.createEmpty().setPayload(value);
        }
        return PrimitiveTypedPayload.ofNull();
    }

    @Override
    public void writeManagedField(AccessorOp op, IManagedVar<?> field, ITypedPayload<?> payload) {
        PrimitiveTypedPayload primitive;
        if (payload instanceof ObjectTypedPayload) {
            ObjectTypedPayload object = (ObjectTypedPayload)payload;
            field.set(object.getPayload());
        }
        if (payload instanceof PrimitiveTypedPayload && (primitive = (PrimitiveTypedPayload)payload).isNull()) {
            field.set(null);
        }
    }
}

