/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.IAccessor;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.accessor.IArrayLikeAccessor;
import com.lowdragmc.lowdraglib.syncdata.accessor.ReadonlyAccessor;
import com.lowdragmc.lowdraglib.syncdata.managed.ManagedHolder;
import com.lowdragmc.lowdraglib.syncdata.payload.ArrayPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import java.util.Collection;
import java.util.Iterator;

public class CollectionAccessor
extends ReadonlyAccessor
implements IArrayLikeAccessor {
    private final IAccessor childAccessor;
    private final Class<?> childType;

    @Override
    public byte getDefaultType() {
        return TypedPayloadRegistries.getId(ArrayPayload.class);
    }

    public CollectionAccessor(IAccessor childAccessor, Class<?> childType) {
        this.childAccessor = childAccessor;
        this.childType = childType;
    }

    @Override
    public boolean hasPredicate() {
        return true;
    }

    @Override
    public boolean test(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    @Override
    public ITypedPayload<?> readFromReadonlyField(AccessorOp op, Object obj) {
        if (!(obj instanceof Collection)) {
            throw new IllegalArgumentException("Field %s is not Collection".formatted(obj));
        }
        Collection collection = (Collection)obj;
        Iterator iter = collection.iterator();
        int size = collection.size();
        ITypedPayload[] result = new ITypedPayload[size];
        if (!this.childAccessor.isManaged()) {
            throw new IllegalArgumentException("Child accessor %s is not managed".formatted(this.childAccessor));
        }
        for (int i = 0; i < size; ++i) {
            ITypedPayload<?> payload;
            Object element = iter.next();
            ManagedHolder holder = ManagedHolder.of(element);
            result[i] = payload = this.childAccessor.readManagedField(op, holder);
        }
        return ArrayPayload.of(result);
    }

    @Override
    public void writeToReadonlyField(AccessorOp op, Object obj, ITypedPayload<?> payload) {
        if (!(obj instanceof Collection)) {
            throw new IllegalArgumentException("Field %s is not Collection".formatted(obj));
        }
        if (!(payload instanceof ArrayPayload)) {
            throw new IllegalArgumentException("Payload %s is not ArrayPayload".formatted(payload));
        }
        ArrayPayload arrayPayload = (ArrayPayload)payload;
        Collection collection = (Collection)obj;
        ITypedPayload[] array = (ITypedPayload[])arrayPayload.getPayload();
        if (!this.childAccessor.isManaged()) {
            throw new IllegalArgumentException("Child accessor %s is not managed".formatted(this.childAccessor));
        }
        collection.clear();
        for (ITypedPayload element : array) {
            ManagedHolder<?> holder = ManagedHolder.ofType(this.childType);
            this.childAccessor.writeManagedField(op, holder, element);
            collection.add(holder.value());
        }
    }

    @Override
    public IAccessor getChildAccessor() {
        return this.childAccessor;
    }
}

