/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.networking.forge;

import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.INetworking;
import com.lowdragmc.lowdraglib.networking.IPacket;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class Networking
implements INetworking {
    protected final ResourceLocation networkingName;
    protected final String version;
    protected final SimpleChannel network;
    protected int AUTO_ID = 0;

    public Networking(ResourceLocation location, String version) {
        this.networkingName = location;
        this.version = version;
        this.network = NetworkRegistry.newSimpleChannel((ResourceLocation)location, () -> version, version::equals, version::equals);
    }

    public <MSG extends IPacket> void register(Class<MSG> clazz, NetworkDirection direction) {
        this.network.registerMessage(this.AUTO_ID++, clazz, IPacket::encode, buffer -> {
            try {
                IPacket packet = (IPacket)clazz.newInstance();
                packet.decode((FriendlyByteBuf)buffer);
                return packet;
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return null;
            }
        }, (msg, ctx) -> {
            final NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            context.enqueueWork(() -> msg.execute(new IHandlerContext(){

                @Override
                public Object getContext() {
                    return context;
                }

                @Override
                public boolean isClient() {
                    return context.getDirection() == NetworkDirection.PLAY_TO_CLIENT;
                }

                @Override
                public ServerPlayer getPlayer() {
                    return context.getSender();
                }

                @Override
                public MinecraftServer getServer() {
                    return context.getSender() == null ? null : context.getSender().m_20194_();
                }

                @Override
                public Level getLevel() {
                    if (this.isClient()) {
                        return ((Optional)LogicalSidedProvider.CLIENTWORLD.get(context.getDirection().getReceptionSide())).orElse(null);
                    }
                    return this.getPlayer() == null ? null : this.getPlayer().m_9236_();
                }
            }));
            context.setPacketHandled(true);
        }, Optional.ofNullable(direction));
    }

    @Override
    public <MSG extends IPacket> void registerC2S(Class<MSG> clazz) {
        this.register(clazz, NetworkDirection.PLAY_TO_SERVER);
    }

    @Override
    public <MSG extends IPacket> void registerS2C(Class<MSG> clazz) {
        this.register(clazz, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public <MSG extends IPacket> void registerBoth(Class<MSG> clazz) {
        this.register(clazz, null);
    }

    public <T> void send(PacketDistributor.PacketTarget target, T packet) {
        this.network.send(target, packet);
    }

    @Override
    public void sendToServer(IPacket msg) {
        this.network.sendToServer((Object)msg);
    }

    @Override
    public void sendToPlayer(IPacket msg, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            this.network.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @Override
    public void sendToTrackingChunk(IPacket packet, LevelChunk levelChunk) {
        this.send(PacketDistributor.TRACKING_CHUNK.with(() -> levelChunk), packet);
    }

    @Override
    public void sendToAll(IPacket msg) {
        this.send(PacketDistributor.ALL.noArg(), msg);
    }

    @Override
    public ResourceLocation getNetworkingName() {
        return this.networkingName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

