/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class FluidStorage
implements IFluidStorage,
IContentChangeAware,
ITagSerializable<CompoundTag> {
    private Runnable onContentsChanged = () -> {};
    protected Predicate<FluidStack> validator;
    @Nonnull
    protected FluidStack fluid = FluidStack.empty();
    protected long capacity;

    public FluidStorage(long capacity) {
        this(capacity, e -> true);
    }

    public FluidStorage(long capacity, Predicate<FluidStack> validator) {
        this.capacity = capacity;
        this.validator = validator;
    }

    public FluidStorage(FluidStack fluidStack) {
        this(fluidStack.getAmount());
        this.fluid = fluidStack;
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
        this.onContentsChanged();
    }

    @Override
    public boolean isFluidValid(FluidStack stack) {
        return this.validator.test(stack);
    }

    @Override
    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChange) {
        if (tank >= this.getTanks() || resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0L;
        }
        if (simulate) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0L;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.fluid = FluidStack.create(resource, Math.min(this.capacity, resource.getAmount()));
            if (notifyChange) {
                this.onContentsChanged();
            }
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0L;
        }
        long filled = this.capacity - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluid.setAmount(this.capacity);
        }
        if (filled > 0L && notifyChange) {
            this.onContentsChanged();
        }
        return filled;
    }

    @Override
    @NotNull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChange) {
        if (tank >= this.getTanks() || resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.empty();
        }
        return this.drain(resource.getAmount(), simulate, notifyChange);
    }

    @Override
    public void onContentsChanged() {
        this.onContentsChanged.run();
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        return this.fluid.copy();
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
        if (snapshot instanceof FluidStack) {
            FluidStack stack = (FluidStack)snapshot;
            this.fluid = stack.copy();
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        return this.fluid.saveToTag(new CompoundTag());
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.setFluid(FluidStack.loadFromTag(nbt));
    }

    public FluidStorage copy() {
        FluidStorage storage = new FluidStorage(this.capacity, this.validator);
        storage.setFluid(this.fluid.copy());
        return storage;
    }

    @Override
    public boolean supportsFill(int tank) {
        return true;
    }

    @Override
    public boolean supportsDrain(int tank) {
        return true;
    }

    @Override
    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    @Override
    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }

    public void setValidator(Predicate<FluidStack> validator) {
        this.validator = validator;
    }

    @Override
    @Nonnull
    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }
}

