/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.scene.FBOWorldSceneRenderer;
import com.lowdragmc.lowdraglib.client.scene.ISceneBlockRenderHook;
import com.lowdragmc.lowdraglib.client.scene.ImmediateWorldSceneRenderer;
import com.lowdragmc.lowdraglib.client.scene.ParticleManager;
import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.lowdraglib.utils.interpolate.Eases;
import com.lowdragmc.lowdraglib.utils.interpolate.Interpolator;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class SceneWidget
extends WidgetGroup {
    @OnlyIn(value=Dist.CLIENT)
    protected WorldSceneRenderer renderer;
    @OnlyIn(value=Dist.CLIENT)
    protected TrackedDummyWorld dummyWorld;
    protected boolean dragging;
    protected boolean renderFacing = true;
    protected boolean renderSelect = true;
    protected boolean draggable = true;
    protected boolean scalable = true;
    protected boolean intractable = true;
    protected boolean hoverTips;
    protected int currentMouseX;
    protected int currentMouseY;
    protected Vector3f center;
    protected float rotationYaw = 25.0f;
    protected float rotationPitch = -135.0f;
    protected float zoom = 5.0f;
    protected float range;
    protected BlockPosFace clickPosFace;
    protected BlockPosFace hoverPosFace;
    protected BlockPosFace selectedPosFace;
    protected ItemStack hoverItem;
    protected BiConsumer<BlockPos, Direction> onSelected;
    protected Set<BlockPos> core;
    protected boolean useCache;
    protected boolean useOrtho = false;
    protected boolean autoReleased;
    protected BiConsumer<SceneWidget, List<Component>> onAddedTooltips;
    protected Consumer<SceneWidget> beforeWorldRender;
    protected Consumer<SceneWidget> afterWorldRender;
    protected Interpolator interpolator;
    protected long startTick;

    public SceneWidget(int x, int y, int width, int height, Level world, boolean useFBO) {
        super(x, y, width, height);
        if (this.isRemote()) {
            this.createScene(world, useFBO);
        }
    }

    public SceneWidget(int x, int y, int width, int height, Level world) {
        super(x, y, width, height);
        if (this.isRemote()) {
            this.createScene(world);
        }
    }

    public SceneWidget setOnAddedTooltips(BiConsumer<SceneWidget, List<Component>> onAddedTooltips) {
        this.onAddedTooltips = onAddedTooltips;
        return this;
    }

    public SceneWidget useCacheBuffer() {
        return this.useCacheBuffer(true);
    }

    public SceneWidget useCacheBuffer(boolean autoReleased) {
        this.useCache = true;
        this.autoReleased = autoReleased;
        if (this.isRemote() && this.renderer != null) {
            this.renderer.useCacheBuffer(true);
        }
        return this;
    }

    public SceneWidget useOrtho() {
        return this.useOrtho(true);
    }

    public SceneWidget useOrtho(boolean useOrtho) {
        this.useOrtho = useOrtho;
        if (this.isRemote() && this.renderer != null) {
            this.renderer.useOrtho(useOrtho);
        }
        return this;
    }

    public SceneWidget setBeforeWorldRender(Consumer<SceneWidget> beforeWorldRender) {
        this.beforeWorldRender = beforeWorldRender;
        if (this.beforeWorldRender != null && this.isRemote() && this.renderer != null) {
            this.renderer.setBeforeWorldRender((WorldSceneRenderer s) -> beforeWorldRender.accept(this));
        }
        return this;
    }

    public SceneWidget setAfterWorldRender(Consumer<SceneWidget> afterWorldRender) {
        this.afterWorldRender = afterWorldRender;
        return this;
    }

    public float camZoom() {
        if (this.useOrtho) {
            return 0.1f;
        }
        return this.zoom;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleManager getParticleManager() {
        if (this.renderer == null) {
            return null;
        }
        return this.renderer.getParticleManager();
    }

    @Override
    public void setGui(ModularUI gui) {
        super.setGui(gui);
        if (gui == null) {
            if (this.isInitialized()) {
                this.releaseCacheBuffer();
            }
        } else {
            gui.registerCloseListener(this::releaseCacheBuffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        ParticleManager particleManager = this.getParticleManager();
        if (particleManager != null) {
            particleManager.tick();
        }
    }

    public void releaseCacheBuffer() {
        if (this.isRemote() && this.renderer != null && this.autoReleased) {
            this.renderer.deleteCacheBuffer();
        }
    }

    public void needCompileCache() {
        if (this.isRemote() && this.renderer != null) {
            this.renderer.needCompileCache();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void createScene(Level world) {
        this.createScene(world, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected ParticleManager createParticleManager() {
        return new ParticleManager();
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void createScene(Level world, boolean useFBOSceneRenderer) {
        if (world == null) {
            return;
        }
        this.core = new HashSet<BlockPos>();
        this.dummyWorld = new TrackedDummyWorld(world);
        this.dummyWorld.setRenderFilter(pos -> {
            Set<Collection<BlockPos>> renderedBlocks = this.renderer.renderedBlocksMap.keySet();
            for (Collection<BlockPos> blocks : renderedBlocks) {
                if (!blocks.contains(pos)) continue;
                return true;
            }
            return false;
        });
        if (this.renderer != null) {
            this.renderer.deleteCacheBuffer();
        }
        this.renderer = useFBOSceneRenderer ? new FBOWorldSceneRenderer(this.dummyWorld, 1080, 1080) : new ImmediateWorldSceneRenderer(this.dummyWorld);
        this.center = new Vector3f(0.0f, 0.0f, 0.0f);
        this.renderer.useOrtho(this.useOrtho);
        this.renderer.setOnLookingAt(ray -> {});
        this.renderer.setBeforeBatchEnd(this::renderBeforeBatchEnd);
        this.renderer.setAfterWorldRender(this::renderBlockOverLay);
        if (this.beforeWorldRender != null) {
            this.renderer.setBeforeWorldRender((WorldSceneRenderer s) -> this.beforeWorldRender.accept(this));
        }
        this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        this.renderer.useCacheBuffer(this.useCache);
        this.renderer.setParticleManager(this.createParticleManager());
        this.clickPosFace = null;
        this.hoverPosFace = null;
        this.hoverItem = null;
        this.selectedPosFace = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public WorldSceneRenderer getRenderer() {
        return this.renderer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TrackedDummyWorld getDummyWorld() {
        return this.dummyWorld;
    }

    public SceneWidget setOnSelected(BiConsumer<BlockPos, Direction> onSelected) {
        this.onSelected = onSelected;
        return this;
    }

    public SceneWidget setClearColor(int color) {
        if (this.isRemote()) {
            this.renderer.setClearColor(color);
        }
        return this;
    }

    public SceneWidget setRenderSelect(boolean renderSelect) {
        this.renderSelect = renderSelect;
        return this;
    }

    public SceneWidget setRenderFacing(boolean renderFacing) {
        this.renderFacing = renderFacing;
        return this;
    }

    public SceneWidget setDraggable(boolean draggable) {
        this.draggable = draggable;
        return this;
    }

    public SceneWidget setScalable(boolean scalable) {
        this.scalable = scalable;
        return this;
    }

    public SceneWidget setIntractable(boolean intractable) {
        this.intractable = intractable;
        return this;
    }

    public SceneWidget setHoverTips(boolean hoverTips) {
        this.hoverTips = hoverTips;
        return this;
    }

    public SceneWidget setRenderedCore(Collection<BlockPos> blocks) {
        return this.setRenderedCore(blocks, null);
    }

    public SceneWidget setRenderedCore(Collection<BlockPos> blocks, ISceneBlockRenderHook renderHook) {
        if (this.isRemote()) {
            this.core.clear();
            this.core.addAll(blocks);
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (BlockPos vPos : blocks) {
                minX = Math.min(minX, vPos.m_123341_());
                minY = Math.min(minY, vPos.m_123342_());
                minZ = Math.min(minZ, vPos.m_123343_());
                maxX = Math.max(maxX, vPos.m_123341_());
                maxY = Math.max(maxY, vPos.m_123342_());
                maxZ = Math.max(maxZ, vPos.m_123343_());
            }
            this.center = new Vector3f((float)(minX + maxX) / 2.0f + 0.5f, (float)(minY + maxY) / 2.0f + 0.5f, (float)(minZ + maxZ) / 2.0f + 0.5f);
            this.renderer.addRenderedBlocks(this.core, renderHook);
            this.zoom = (float)(3.5 * Math.sqrt(Math.max(Math.max(Math.max(maxX - minX + 1, maxY - minY + 1), maxZ - minZ + 1), 1)));
            this.renderer.setCameraOrtho(this.range * this.zoom, this.range * this.zoom, this.range * this.zoom);
            this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            this.needCompileCache();
        }
        return this;
    }

    private List<Component> getToolTips(List<Component> list) {
        if (this.onAddedTooltips != null) {
            this.onAddedTooltips.accept(this, list);
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderBeforeBatchEnd(MultiBufferSource bufferSource, float partialTicks) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderBlockOverLay(WorldSceneRenderer renderer) {
        BlockPosFace tmp;
        BlockHitResult hit;
        PoseStack poseStack = new PoseStack();
        this.hoverPosFace = null;
        this.hoverItem = null;
        if (this.isMouseOverElement(this.currentMouseX, this.currentMouseY) && (hit = renderer.getLastTraceResult()) != null) {
            if (this.core.contains(hit.m_82425_())) {
                this.hoverPosFace = new BlockPosFace(hit.m_82425_(), hit.m_82434_());
            } else if (!this.useOrtho) {
                Vector3f hitPos = hit.m_82450_().m_252839_();
                Level world = renderer.world;
                Vec3 eyePos = new Vec3(renderer.getEyePos());
                hitPos.mul(2.0f);
                Vec3 endPos = new Vec3((double)hitPos.x - eyePos.f_82479_, (double)hitPos.y - eyePos.f_82480_, (double)hitPos.z - eyePos.f_82481_);
                double min = 3.4028234663852886E38;
                for (BlockPos pos : this.core) {
                    double dist;
                    BlockState blockState = world.m_8055_(pos);
                    if (blockState.m_60734_() == Blocks.f_50016_ || (hit = world.m_45558_(eyePos, endPos, pos, blockState.m_60808_((BlockGetter)world, pos), blockState)) == null || hit.m_6662_() == HitResult.Type.MISS || !((dist = eyePos.m_82557_(hit.m_82450_())) < min)) continue;
                    min = dist;
                    this.hoverPosFace = new BlockPosFace(hit.m_82425_(), hit.m_82434_());
                }
            }
        }
        if (this.hoverPosFace != null) {
            BlockState state = this.getDummyWorld().m_8055_(this.hoverPosFace.pos);
            this.hoverItem = state.m_60734_().m_7397_((BlockGetter)this.getDummyWorld(), this.hoverPosFace.pos, state);
        }
        BlockPosFace blockPosFace = tmp = this.dragging ? this.clickPosFace : this.hoverPosFace;
        if (this.selectedPosFace != null || tmp != null) {
            if (this.selectedPosFace != null && this.renderFacing) {
                this.drawFacingBorder(poseStack, this.selectedPosFace, -16711936);
            }
            if (tmp != null && !tmp.equals(this.selectedPosFace) && this.renderFacing) {
                this.drawFacingBorder(poseStack, tmp, -1);
            }
        }
        if (this.selectedPosFace != null && this.renderSelect) {
            RenderUtils.renderBlockOverLay(poseStack, this.selectedPosFace.pos, 0.6f, 0.0f, 0.0f, 1.01f);
        }
        if (this.afterWorldRender != null) {
            this.afterWorldRender.accept(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawFacingBorder(PoseStack poseStack, BlockPosFace posFace, int color) {
        this.drawFacingBorder(poseStack, posFace, color, 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawFacingBorder(PoseStack poseStack, BlockPosFace posFace, int color, int inner) {
        poseStack.m_85836_();
        RenderSystem.disableDepthTest();
        RenderUtils.moveToFace(poseStack, posFace.pos.m_123341_(), posFace.pos.m_123342_(), posFace.pos.m_123343_(), posFace.facing);
        RenderUtils.rotateToFace(poseStack, posFace.facing, null);
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0f);
        poseStack.m_252880_(-8.0f, -8.0f, 0.0f);
        SceneWidget.drawBorder(poseStack, 1 + inner * 2, 1 + inner * 2, 14 - 4 * inner, 14 - 4 * inner, color, 1);
        RenderSystem.enableDepthTest();
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawBorder(PoseStack poseStack, int x, int y, int width, int height, int color, int border) {
        SceneWidget.drawSolidRect(poseStack, x - border, y - border, width + 2 * border, border, color);
        SceneWidget.drawSolidRect(poseStack, x - border, y + height, width + 2 * border, border, color);
        SceneWidget.drawSolidRect(poseStack, x - border, y, border, height, color);
        SceneWidget.drawSolidRect(poseStack, x + width, y, border, height, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawSolidRect(PoseStack poseStack, int x, int y, int width, int height, int color) {
        SceneWidget.fill(poseStack, x, y, x + width, y + height, 0, color);
        RenderSystem.enableBlend();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void fill(PoseStack matrices, int x1, int y1, int x2, int y2, int z, int color) {
        int i;
        Matrix4f matrix4f = matrices.m_85850_().m_252922_();
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float f = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float h = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float j = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y1, (float)z).m_85950_(g, h, j, f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y2, (float)z).m_85950_(g, h, j, f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y2, (float)z).m_85950_(g, h, j, f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y1, (float)z).m_85950_(g, h, j, f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    @Override
    public Object getXEIIngredientOverMouse(double mouseX, double mouseY) {
        Object result = super.getXEIIngredientOverMouse(mouseX, mouseY);
        if (result == null && this.hoverItem != null && !this.hoverItem.m_41619_()) {
            if (LDLib.isJeiLoaded()) {
                return JEIPlugin.getItemIngredient(this.hoverItem, (int)mouseX, (int)mouseY, 1, 1);
            }
            if (LDLib.isReiLoaded()) {
                return EntryStacks.of((ItemStack)this.hoverItem);
            }
            if (LDLib.isEmiLoaded()) {
                return EmiStack.of((ItemStack)this.hoverItem);
            }
            return this.hoverItem;
        }
        return result;
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        if (id == -1) {
            this.selectedPosFace = new BlockPosFace(buffer.m_130135_(), (Direction)buffer.m_130066_(Direction.class));
            if (this.onSelected != null) {
                this.onSelected.accept(this.selectedPosFace.pos, this.selectedPosFace.facing);
            }
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (!this.intractable) {
            return false;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.draggable) {
                this.dragging = true;
            }
            this.clickPosFace = this.hoverPosFace;
            return true;
        }
        this.dragging = false;
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        boolean result = super.mouseWheelMove(mouseX, mouseY, wheelDelta);
        if (!this.intractable) {
            return result;
        }
        if (!result && this.isMouseOverElement(mouseX, mouseY) && this.scalable) {
            this.zoom = (float)Mth.m_14008_((double)((double)this.zoom + (wheelDelta < 0.0 ? 0.5 : -0.5)), (double)0.1, (double)999.0);
            if (this.renderer != null) {
                this.renderer.setCameraOrtho(this.range * this.zoom, this.range * this.zoom, this.range * this.zoom);
                this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            }
            return true;
        }
        return result;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.intractable) {
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        if (this.dragging) {
            this.rotationPitch = (float)((double)this.rotationPitch + (dragX + 360.0));
            this.rotationPitch %= 360.0f;
            this.rotationYaw = (float)Mth.m_14008_((double)((double)this.rotationYaw + dragY), (double)-89.9, (double)89.9);
            if (this.renderer != null) {
                this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            }
            return false;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.intractable) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        this.dragging = false;
        if (this.hoverPosFace != null && this.hoverPosFace.equals(this.clickPosFace)) {
            this.selectedPosFace = this.hoverPosFace;
            this.writeClientAction(-1, buffer -> {
                buffer.m_130064_(this.selectedPosFace.pos);
                buffer.m_130068_((Enum)this.selectedPosFace.facing);
            });
            if (this.onSelected != null) {
                this.onSelected.accept(this.selectedPosFace.pos, this.selectedPosFace.facing);
            }
            this.clickPosFace = null;
            return true;
        }
        this.clickPosFace = null;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull @NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.hoverTips && this.isMouseOverElement(mouseX, mouseY) && this.hoverItem != null && !this.hoverItem.m_41619_()) {
            this.gui.getModularUIGui().setHoverTooltip(this.getToolTips(DrawerHelper.getItemToolTip(this.hoverItem)), this.hoverItem, null, this.hoverItem.m_150921_().orElse(null));
        }
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawBackgroundTexture(graphics, mouseX, mouseY);
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.interpolator != null) {
            this.interpolator.update((float)this.gui.getTickCount() + partialTicks);
        }
        if (this.renderer != null) {
            double progress;
            this.renderer.render(graphics.m_280168_(), x, y, width, height, mouseX, mouseY);
            if (this.renderer.isCompiling() && (progress = this.renderer.getCompileProgress()) > 0.0) {
                new TextTexture("Renderer is compiling! " + String.format("%.1f", progress * 100.0) + "%%").setWidth(width).draw(graphics, mouseX, mouseY, x, y, width, height);
            }
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        this.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
        this.drawOverlay(graphics, mouseX, mouseY, partialTicks);
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
    }

    public SceneWidget setCenter(Vector3f center) {
        this.center = center;
        if (this.renderer != null) {
            this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        }
        return this;
    }

    public SceneWidget setZoom(float zoom) {
        this.zoom = zoom;
        if (this.renderer != null) {
            this.renderer.setCameraOrtho(this.range * zoom, this.range * zoom, this.range * zoom);
            this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        }
        return this;
    }

    public SceneWidget setOrthoRange(float range) {
        this.range = range;
        if (this.renderer != null) {
            this.renderer.setCameraOrtho(range * this.zoom, range * this.zoom, range * this.zoom);
        }
        return this;
    }

    public SceneWidget setCameraYawAndPitch(float rotationYaw, float rotationPitch) {
        this.rotationYaw = rotationYaw;
        this.rotationPitch = rotationPitch;
        if (this.renderer != null) {
            this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(rotationPitch), Math.toRadians(rotationYaw));
        }
        return this;
    }

    public void setCameraYawAndPitchAnima(float rotationYaw, float rotationPitch, int dur) {
        if (this.interpolator != null) {
            return;
        }
        float oRotationYaw = this.rotationYaw;
        float oRotationPitch = this.rotationPitch;
        this.startTick = this.gui.getTickCount();
        this.interpolator = new Interpolator(0.0f, 1.0f, dur, Eases.EaseQuadOut, value -> {
            this.rotationYaw = (rotationYaw - oRotationYaw) * value.floatValue() + oRotationYaw;
            this.rotationPitch = (rotationPitch - oRotationPitch) * value.floatValue() + oRotationPitch;
            if (this.renderer != null) {
                this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            }
        }, x -> {
            this.interpolator = null;
        });
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isRenderFacing() {
        return this.renderFacing;
    }

    public boolean isRenderSelect() {
        return this.renderSelect;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public boolean isScalable() {
        return this.scalable;
    }

    public boolean isIntractable() {
        return this.intractable;
    }

    public boolean isHoverTips() {
        return this.hoverTips;
    }

    public int getCurrentMouseX() {
        return this.currentMouseX;
    }

    public int getCurrentMouseY() {
        return this.currentMouseY;
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public float getRotationYaw() {
        return this.rotationYaw;
    }

    public float getRotationPitch() {
        return this.rotationPitch;
    }

    public float getZoom() {
        return this.zoom;
    }

    public float getRange() {
        return this.range;
    }

    public BlockPosFace getClickPosFace() {
        return this.clickPosFace;
    }

    public BlockPosFace getHoverPosFace() {
        return this.hoverPosFace;
    }

    public BlockPosFace getSelectedPosFace() {
        return this.selectedPosFace;
    }

    public ItemStack getHoverItem() {
        return this.hoverItem;
    }

    public BiConsumer<BlockPos, Direction> getOnSelected() {
        return this.onSelected;
    }

    public Set<BlockPos> getCore() {
        return this.core;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public boolean isUseOrtho() {
        return this.useOrtho;
    }

    public boolean isAutoReleased() {
        return this.autoReleased;
    }
}

