/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.TabButton;
import com.lowdragmc.lowdraglib.gui.widget.TabContainer;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringTabContainer
extends TabContainer {
    public static final int TAB_HEIGHT = 16;
    protected Editor editor;
    protected final Map<WidgetGroup, Runnable> onSelected;
    protected final Map<WidgetGroup, Runnable> onDeselected;
    public BiConsumer<WidgetGroup, WidgetGroup> onChanged;
    private final List<WidgetGroup> tabGroups;

    public StringTabContainer(Editor editor) {
        super(0, 0, editor.getSize().width - editor.getConfigPanel().getSize().width, editor.getSize().height);
        this.editor = editor;
        this.onSelected = new HashMap<WidgetGroup, Runnable>();
        this.onDeselected = new HashMap<WidgetGroup, Runnable>();
        this.tabGroups = new ArrayList<WidgetGroup>();
        super.setOnChanged(this::onTabChanged);
    }

    public int getTabIndex() {
        if (this.focus == null) {
            return -1;
        }
        return this.tabGroups.indexOf(this.focus);
    }

    public int getTabIndex(WidgetGroup group) {
        return this.tabGroups.indexOf(group);
    }

    public void switchTabIndex(int index) {
        if (this.tabGroups.size() > index && index >= 0) {
            this.switchTag(this.tabGroups.get(index));
        }
    }

    @Override
    public void clearAllWidgets() {
        super.clearAllWidgets();
        this.onSelected.clear();
        this.onDeselected.clear();
        this.tabGroups.clear();
    }

    @Override
    public TabContainer setOnChanged(BiConsumer<WidgetGroup, WidgetGroup> onChanged) {
        this.onChanged = onChanged;
        return this;
    }

    protected void onTabChanged(WidgetGroup oldGroup, WidgetGroup newGroup) {
        Optional.ofNullable(this.onDeselected.get(oldGroup)).ifPresent(Runnable::run);
        Optional.ofNullable(this.onSelected.get(newGroup)).ifPresent(Runnable::run);
        if (this.onChanged != null) {
            this.onChanged.accept(oldGroup, newGroup);
        }
    }

    @Override
    public final void addTab(TabButton tabButton, WidgetGroup tabWidget) {
        super.addTab(tabButton, tabWidget);
        this.tabGroups.add(tabWidget);
    }

    @Override
    public void removeTab(TabButton tabButton) {
        WidgetGroup group = (WidgetGroup)this.tabs.get((Object)tabButton);
        int lastIndex = this.getTabIndex(group);
        super.removeTab(tabButton);
        this.tabGroups.remove(group);
        if (this.focus == group) {
            Optional.ofNullable(this.onDeselected.get(group)).ifPresent(Runnable::run);
            this.focus = null;
            if (lastIndex > 0) {
                this.switchTabIndex(lastIndex - 1);
            }
        }
        this.onSelected.remove(group);
        this.onDeselected.remove(group);
        this.calculateTabSize();
    }

    public void addTab(final @Nullable IGuiTexture icon, String name, WidgetGroup group, @Nullable Runnable onSelected, @Nullable Runnable onDeselected, final @Nullable Runnable onRemoved) {
        final TextTexture nameTexture = new TextTexture(name).setType(TextTexture.TextType.ROLL);
        TabButton tabButton = new TabButton(0, 0, 60, 14){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                int textWidth;
                super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
                Position position = this.getPosition();
                Size size = this.getSize();
                if (icon != null) {
                    icon.draw(graphics, mouseX, mouseY, position.x + 2, position.y + 2, 12, 12);
                }
                if ((textWidth = size.width - (icon == null ? 0 : 16) - (onRemoved == null ? 0 : 16)) != nameTexture.width) {
                    nameTexture.setWidth(textWidth);
                }
                nameTexture.draw(graphics, mouseX, mouseY, position.x + (icon == null ? 0 : 16), position.y, textWidth, size.height);
                if (onRemoved != null) {
                    if (1.isMouseOver(position.x + size.width - 16, position.y, 12, 12, mouseX, mouseY)) {
                        Icons.REMOVE.copy().setColor(ColorPattern.GREEN.color).draw(graphics, mouseX, mouseY, position.x + size.width - 16, position.y, 12, 12);
                    } else {
                        Icons.REMOVE.draw(graphics, mouseX, mouseY, position.x + size.width - 16, position.y, 12, 12);
                    }
                }
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (onRemoved != null) {
                    Position position = this.getPosition();
                    Size size = this.getSize();
                    if (1.isMouseOver(position.x + size.width - 16, position.y, 12, 12, mouseX, mouseY)) {
                        onRemoved.run();
                        StringTabContainer.this.removeTab(this);
                        StringTabContainer.this.calculateTabSize();
                        return true;
                    }
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }
        };
        tabButton.setTexture(new GuiTextureGroup(ColorPattern.T_GRAY.rectTexture()), new GuiTextureGroup(ColorPattern.T_RED.rectTexture()));
        if (onSelected != null) {
            this.onSelected.put(group, onSelected);
        }
        if (onDeselected != null) {
            this.onDeselected.put(group, onDeselected);
        }
        this.addTab(tabButton, group);
        if (this.focus == group && onSelected != null) {
            onSelected.run();
        }
        this.calculateTabSize();
    }

    public void addTab(String name, WidgetGroup group, @Nullable Runnable onSelected, @Nullable Runnable onDeselected) {
        this.addTab(null, name, group, onSelected, onDeselected, null);
    }

    public void addTab(String name, WidgetGroup group, Runnable onSelected) {
        this.addTab(name, group, onSelected, null);
    }

    public void addTab(String name, WidgetGroup group) {
        this.addTab(name, group, null, null);
    }

    public void calculateTabSize() {
        int tabWidth = (this.getSize().getWidth() - 1 - this.tabs.size()) / this.tabs.size();
        int x = 1;
        int y = this.editor.getMenuPanel().getSize().height + 1;
        for (TabButton tabButton : this.tabs.keySet()) {
            tabButton.setSelfPosition(new Position(x, y));
            tabButton.setSize(new Size(tabWidth, 14));
            x += tabWidth + 1;
        }
    }

    public Editor getEditor() {
        return this.editor;
    }

    public Map<WidgetGroup, Runnable> getOnSelected() {
        return this.onSelected;
    }

    public Map<WidgetGroup, Runnable> getOnDeselected() {
        return this.onDeselected;
    }

    public BiConsumer<WidgetGroup, WidgetGroup> getOnChanged() {
        return this.onChanged;
    }

    public List<WidgetGroup> getTabGroups() {
        return this.tabGroups;
    }
}

