/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui;

import com.lowdragmc.lowdraglib.gui.animation.Transform;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TabButton;
import com.lowdragmc.lowdraglib.gui.widget.TabContainer;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.interpolate.Eases;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public class ResourcePanel
extends WidgetGroup {
    public static final int HEIGHT = 100;
    protected Editor editor;
    protected ButtonWidget buttonHide;
    protected TabContainer tabContainer;
    @Nullable
    protected Resources resources;
    protected boolean isShow = true;
    protected Map<Resource, ResourceContainer> containerMap = new HashMap<Resource, ResourceContainer>();

    public ResourcePanel(Editor editor) {
        super(0, editor.getSize().height - 100, editor.getSize().getWidth() - 252, 100);
        this.setClientSideWidget();
        this.editor = editor;
    }

    private void dispose() {
        if (this.resources != null) {
            this.resources.dispose();
        }
    }

    @Override
    public void setGui(ModularUI gui) {
        super.setGui(gui);
        if (gui == null) {
            this.dispose();
        } else {
            this.getGui().registerCloseListener(this::dispose);
        }
    }

    @Override
    public void initWidget() {
        Size size = this.getSize();
        this.setBackground(ColorPattern.BLACK.rectTexture());
        this.buttonHide = new ButtonWidget((this.getSize().width - 30) / 2, -10, 30, 10, new GuiTextureGroup(ColorPattern.BLACK.rectTexture(), ColorPattern.T_GRAY.borderTexture(1), Icons.DOWN), cd -> {
            if (this.isShow()) {
                this.hide();
            } else {
                this.show();
            }
        }).setHoverBorderTexture(1, -1);
        this.addWidget(this.buttonHide);
        this.addWidget(new LabelWidget(3, 3, "ldlib.gui.editor.group.resources"));
        this.tabContainer = new TabContainer(0, 15, size.width, size.height - 14);
        this.addWidget(this.tabContainer);
        this.tabContainer.setBackground(ColorPattern.T_GRAY.borderTexture(-1));
        super.initWidget();
    }

    public void hide() {
        if (this.isShow() && !this.inAnimate()) {
            this.isShow = !this.isShow;
            this.animation(new Transform().offset(0, 100).ease(Eases.EaseQuadOut).duration(500L).onFinish(() -> {
                this.addSelfPosition(0, 100);
                this.buttonHide.setButtonTexture(ColorPattern.BLACK.rectTexture(), ColorPattern.T_GRAY.borderTexture(1), Icons.UP);
            }));
        }
    }

    public void show() {
        if (!this.isShow() && !this.inAnimate()) {
            this.isShow = !this.isShow;
            this.animation(new Transform().offset(0, -100).ease(Eases.EaseQuadOut).duration(500L).onFinish(() -> {
                this.addSelfPosition(0, -100);
                this.buttonHide.setButtonTexture(ColorPattern.BLACK.rectTexture(), ColorPattern.T_GRAY.borderTexture(1), Icons.DOWN);
            }));
        }
    }

    public void clear() {
        this.tabContainer.clearAllWidgets();
        this.containerMap.clear();
    }

    public void loadResource(Resources resources, boolean merge) {
        this.tabContainer.clearAllWidgets();
        this.containerMap.clear();
        if (!merge && this.resources != null) {
            this.resources.dispose();
        }
        if (!merge || this.resources == null) {
            this.resources = resources;
            resources.load();
        } else {
            this.resources.merge(resources);
        }
        int offset = Minecraft.m_91087_().f_91062_.m_92895_(LocalizationUtils.format("ldlib.gui.editor.group.resources", new Object[0])) + 8;
        int maxWidth = (this.getSize().width - offset) / this.resources.resources.size();
        for (Resource<?> resource : this.resources.resources.values()) {
            int width = Math.min(maxWidth, Minecraft.m_91087_().f_91062_.m_92895_(LocalizationUtils.format(resource.name(), new Object[0])) + 8);
            ResourceContainer<?, Widget> resourceContainer = resource.createContainer(this);
            this.tabContainer.addTab(new TabButton(offset, -15, width, 15).setTexture(new TextTexture(resource.name()).setType(TextTexture.TextType.ROLL).setWidth(width), new GuiTextureGroup(new TextTexture(resource.name(), ColorPattern.T_GREEN.color).setType(TextTexture.TextType.ROLL).setWidth(width), ColorPattern.T_GRAY.rectTexture())), resourceContainer);
            this.containerMap.put(resource, resourceContainer);
            offset += width;
        }
    }

    public void rebuildResource(String resourceName) {
        ResourceContainer container;
        Resource<?> resource;
        if (this.resources != null && (resource = this.resources.resources.get(resourceName)) != null && (container = this.containerMap.get(resource)) != null) {
            container.reBuild();
        }
    }

    public Editor getEditor() {
        return this.editor;
    }

    @Nullable
    public Resources getResources() {
        return this.resources;
    }

    public boolean isShow() {
        return this.isShow;
    }

    public Map<Resource, ResourceContainer> getContainerMap() {
        return this.containerMap;
    }
}

