/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.compass.CompassSection;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.json.SimpleIGuiTextureJsonUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class CompassNode {
    protected final JsonObject config;
    protected ResourceLocation nodeName;
    protected CompassSection section;
    protected Position position;
    protected int size;
    @Nullable
    protected IGuiTexture background;
    @Nullable
    protected IGuiTexture hoverBackground;
    protected IGuiTexture buttonTexture;
    protected Set<CompassNode> preNodes = new HashSet<CompassNode>();
    protected Set<CompassNode> childNodes = new HashSet<CompassNode>();
    protected List<Item> items;

    public CompassNode(ResourceLocation nodeName, JsonObject config) {
        this.config = config;
        this.nodeName = nodeName;
        this.background = config.has("background") ? SimpleIGuiTextureJsonUtils.fromJson(config.get("background").getAsJsonObject()) : null;
        this.hoverBackground = config.has("hover_background") ? SimpleIGuiTextureJsonUtils.fromJson(config.get("hover_background").getAsJsonObject()) : null;
        this.buttonTexture = SimpleIGuiTextureJsonUtils.fromJson(config.get("button_texture").getAsJsonObject());
        JsonArray position = config.get("position").getAsJsonArray();
        this.position = new Position(position.get(0).getAsInt(), position.get(1).getAsInt());
        this.size = GsonHelper.m_13824_((JsonObject)config, (String)"size", (int)24);
    }

    public JsonObject updateJson() {
        JsonArray pos = new JsonArray();
        pos.add((Number)this.position.x);
        pos.add((Number)this.position.y);
        this.config.add("position", (JsonElement)pos);
        this.config.addProperty("section", this.section.sectionName.toString());
        if (this.size != 24) {
            this.config.addProperty("size", (Number)this.size);
        } else {
            this.config.remove("size");
        }
        if (this.background != null) {
            this.config.add("background", (JsonElement)SimpleIGuiTextureJsonUtils.toJson(this.background));
        } else {
            this.config.remove("background");
        }
        if (this.hoverBackground != null) {
            this.config.add("hover_background", (JsonElement)SimpleIGuiTextureJsonUtils.toJson(this.hoverBackground));
        } else {
            this.config.remove("hover_background");
        }
        this.config.add("button_texture", (JsonElement)SimpleIGuiTextureJsonUtils.toJson(this.buttonTexture));
        if (this.preNodes.isEmpty()) {
            this.config.remove("pre_nodes");
        } else {
            JsonArray pre = new JsonArray();
            for (CompassNode node : this.preNodes) {
                pre.add(node.getNodeName().toString());
            }
            this.config.add("pre_nodes", (JsonElement)pre);
        }
        return this.config;
    }

    public void setSection(CompassSection section) {
        this.section = section;
        this.section.addNode(this);
    }

    public void initRelation() {
        if (this.config.has("pre_nodes")) {
            JsonArray pre = this.config.get("pre_nodes").getAsJsonArray();
            for (JsonElement element : pre) {
                ResourceLocation nodeName = new ResourceLocation(element.getAsString());
                CompassNode node = CompassManager.INSTANCE.getNodeByName(nodeName);
                if (node == null) continue;
                this.preNodes.add(node);
                node.childNodes.add(this);
            }
        }
    }

    public final String toString() {
        return this.nodeName.toString();
    }

    public ResourceLocation getPage() {
        return new ResourceLocation(GsonHelper.m_13851_((JsonObject)this.config, (String)"page", (String)"ldlib:missing"));
    }

    public List<Item> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
            JsonArray items = GsonHelper.m_13832_((JsonObject)this.config, (String)"items", (JsonArray)new JsonArray());
            for (JsonElement element : items) {
                String data = element.getAsString();
                if (ResourceLocation.m_135830_((String)data)) {
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(data));
                    if (item == Items.f_41852_) continue;
                    this.items.add(item);
                    continue;
                }
                if (!data.startsWith("#") || !ResourceLocation.m_135830_((String)data.substring(1))) continue;
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(data.substring(1)));
                Optional tagCollection = BuiltInRegistries.f_257033_.m_203431_(tag);
                tagCollection.ifPresent(named -> named.forEach(holder -> this.items.add((Item)holder.m_203334_())));
            }
        }
        return this.items;
    }

    public Component getChatComponent() {
        return Component.m_237115_((String)this.nodeName.m_214296_("compass.node"));
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public ResourceLocation getNodeName() {
        return this.nodeName;
    }

    public CompassNode setNodeName(ResourceLocation nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public CompassSection getSection() {
        return this.section;
    }

    public Position getPosition() {
        return this.position;
    }

    public CompassNode setPosition(Position position) {
        this.position = position;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    @Nullable
    public IGuiTexture getBackground() {
        return this.background;
    }

    @Nullable
    public IGuiTexture getHoverBackground() {
        return this.hoverBackground;
    }

    public CompassNode setBackground(@Nullable IGuiTexture background) {
        this.background = background;
        return this;
    }

    public CompassNode setHoverBackground(@Nullable IGuiTexture hoverBackground) {
        this.hoverBackground = hoverBackground;
        return this;
    }

    public IGuiTexture getButtonTexture() {
        return this.buttonTexture;
    }

    public CompassNode setButtonTexture(IGuiTexture buttonTexture) {
        this.buttonTexture = buttonTexture;
        return this;
    }

    public Set<CompassNode> getPreNodes() {
        return this.preNodes;
    }

    public Set<CompassNode> getChildNodes() {
        return this.childNodes;
    }
}

