/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.core.mixins;

import com.lowdragmc.lowdraglib.client.model.custommodel.LDLMetadataSection;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SpriteResourceLoader.class})
public class SpriteResourceLoaderMixin {
    @Inject(method={"list"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;builder()Lcom/google/common/collect/ImmutableList$Builder;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void injectList(ResourceManager resourceManager, CallbackInfoReturnable<List<Supplier<SpriteContents>>> cir, Map<ResourceLocation, SpriteSource.SpriteSupplier> map, SpriteSource.Output output) {
        for (ResourceLocation spriteName : map.keySet()) {
            LDLMetadataSection data = LDLMetadataSection.getMetadata(LDLMetadataSection.spriteToAbsolute(spriteName));
            if (data.connection == null) continue;
            new SingleFile(data.connection, Optional.empty()).m_260891_(resourceManager, output);
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void injectLoad(ResourceManager resourceManager, ResourceLocation location, CallbackInfoReturnable<SpriteResourceLoader> cir, ResourceLocation resourceLocation, List<SpriteSource> list) {
        ResourceLocation atlas = new ResourceLocation(location.m_135827_(), "textures/atlas/%s.png".formatted(location.m_135815_()));
        HashSet sprites = new HashSet();
        for (IRenderer renderer : IRenderer.EVENT_REGISTERS) {
            renderer.onPrepareTextureAtlas(atlas, sprites::add);
        }
        for (ResourceLocation sprite : sprites) {
            list.add((SpriteSource)new SingleFile(sprite, Optional.empty()));
        }
    }
}

