/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.siteexport;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import guideme.internal.siteexport.WebPExporter;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OffScreenRenderer
implements AutoCloseable {
    private final NativeImage nativeImage;
    private final TextureTarget fb;
    private final int width;
    private final int height;

    public OffScreenRenderer(int width, int height) {
        this.width = width;
        this.height = height;
        RenderSystem.viewport((int)0, (int)0, (int)width, (int)height);
        this.nativeImage = new NativeImage(width, height, true);
        this.fb = new TextureTarget(width, height, true, true);
        this.fb.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        this.fb.m_83954_(true);
    }

    @Override
    public void close() {
        this.nativeImage.close();
        this.fb.m_83930_();
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null) {
            Window window = minecraft.m_91268_();
            RenderSystem.viewport((int)0, (int)0, (int)window.m_85441_(), (int)window.m_85442_());
        }
    }

    public byte[] captureAsPng(Runnable r) {
        this.renderToBuffer(r);
        try {
            return this.nativeImage.m_85121_();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to encode image as PNG", e);
        }
    }

    public void captureAsPng(Runnable r, Path path) throws IOException {
        this.renderToBuffer(r);
        this.nativeImage.m_85066_(path);
    }

    public boolean isAnimated(Collection<TextureAtlasSprite> sprites) {
        return sprites.stream().anyMatch(s -> s.m_245424_().f_244575_ != null);
    }

    public byte[] captureAsWebp(Runnable r, Collection<TextureAtlasSprite> sprites, WebPExporter.Format format) {
        List<TextureAtlasSprite> animatedSprites = sprites.stream().filter(sprite -> sprite.m_245424_().f_244575_ != null).toList();
        if (animatedSprites.isEmpty()) {
            return this.captureAsPng(r);
        }
        int maxTime = animatedSprites.stream().mapToInt(s -> s.m_245424_().f_244575_.f_243714_.stream().mapToInt(value -> value.f_244553_).sum()).max().orElse(0);
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        Map<ResourceLocation, List> tickers = animatedSprites.stream().collect(Collectors.groupingBy(TextureAtlasSprite::m_247685_)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(TextureAtlasSprite::m_247406_).toList()));
        for (TextureAtlasSprite sprite2 : animatedSprites) {
            textureManager.m_118506_(sprite2.m_247685_()).m_117966_();
            sprite2.m_118416_();
        }
        int width = this.nativeImage.m_84982_();
        int height = this.nativeImage.m_85084_();
        try (WebPExporter webpWriter = new WebPExporter(width, height, format);){
            for (int i = 0; i < maxTime; ++i) {
                for (Map.Entry<ResourceLocation, List> entry : tickers.entrySet()) {
                    textureManager.m_118506_(entry.getKey()).m_117966_();
                    for (TextureAtlasSprite.Ticker ticker : entry.getValue()) {
                        ticker.m_245385_();
                    }
                }
                this.renderToBuffer(r);
                webpWriter.writeFrame(i, this.nativeImage);
            }
            byte[] byArray = webpWriter.finish();
            return byArray;
        }
    }

    private void renderToBuffer(Runnable r) {
        this.fb.m_83947_(true);
        GlStateManager._clear((int)16640, (boolean)false);
        r.run();
        this.fb.m_83970_();
        this.fb.m_83956_();
        this.nativeImage.m_85045_(0, false);
        this.nativeImage.m_85122_();
        this.fb.m_83963_();
    }

    public void setupItemRendering() {
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, 16.0f, 16.0f, 0.0f, 1000.0f, 21000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_166856_();
        poseStack.m_252880_(0.0f, 0.0f, -11000.0f);
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
        FogRenderer.m_109017_();
    }

    public void setupOrtographicRendering() {
        float angle = 36.0f;
        float renderHeight = 0.0f;
        float renderScale = 100.0f;
        float rotation = 45.0f;
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().ortho(-1.0f, 1.0f, 1.0f, -1.0f, 1000.0f, 3000.0f), (VertexSorting)VertexSorting.f_276633_);
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_166856_();
        poseStack.m_252880_(0.0f, 0.0f, -2000.0f);
        FogRenderer.m_109017_();
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        poseStack.m_252781_(new Quaternionf().rotationY((float)(-Math.PI)));
        Quaternionf flip = new Quaternionf().rotationZ((float)Math.PI);
        flip.mul((Quaternionfc)new Quaternionf().rotationX((float)Math.PI / 180 * angle));
        poseStack.m_85837_(0.0, (double)renderHeight / -300.0, 0.0);
        poseStack.m_85841_(renderScale * 0.004f, renderScale * 0.004f, 1.0f);
        Quaternionf rotate = new Quaternionf().rotationY((float)Math.PI / 180 * rotation);
        poseStack.m_252781_(flip);
        poseStack.m_252781_(rotate);
        RenderSystem.applyModelViewMatrix();
        Lighting.m_252756_((Matrix4f)poseStack.m_85850_().m_252922_());
    }

    public void setupPerspectiveRendering(float zoom, float fov, Vector3f eyePos, Vector3f lookAt) {
        float aspectRatio = (float)this.width / (float)this.height;
        PoseStack projMat = new PoseStack();
        if (zoom != 1.0f) {
            projMat.m_85841_(zoom, zoom, 1.0f);
        }
        projMat.m_252931_(new Matrix4f().perspective(fov, aspectRatio, 0.05f, 16.0f));
        RenderSystem.setProjectionMatrix((Matrix4f)projMat.m_85850_().m_252922_(), (VertexSorting)VertexSorting.f_276450_);
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_166856_();
        Matrix4f vm = OffScreenRenderer.createViewMatrix(eyePos, lookAt);
        poseStack.m_252931_(vm);
        RenderSystem.applyModelViewMatrix();
        Lighting.m_252756_((Matrix4f)poseStack.m_85850_().m_252922_());
    }

    private static Matrix4f createViewMatrix(Vector3f eyePos, Vector3f lookAt) {
        Vector3f dir = new Vector3f((Vector3fc)lookAt);
        dir.sub((Vector3fc)eyePos);
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        dir.normalize();
        Vector3f right = new Vector3f((Vector3fc)dir);
        right.cross((Vector3fc)up);
        right.normalize();
        up = new Vector3f((Vector3fc)right);
        up.cross((Vector3fc)dir);
        up.normalize();
        Matrix4f viewMatrix = new Matrix4f();
        viewMatrix.setTransposed(FloatBuffer.wrap(new float[]{right.x(), right.y(), right.z(), 0.0f, up.x(), up.y(), up.z(), 0.0f, -dir.x(), -dir.y(), -dir.z(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}));
        viewMatrix.translate(-eyePos.x(), -eyePos.y(), -eyePos.z());
        return viewMatrix;
    }
}

