/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.function;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.ConstantScoreScorer;
import guideme.internal.shaded.lucene.search.ConstantScoreWeight;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.DoubleValues;
import guideme.internal.shaded.lucene.search.DoubleValuesSource;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.TwoPhaseIterator;
import guideme.internal.shaded.lucene.search.Weight;
import java.io.IOException;
import java.util.Objects;
import java.util.function.DoublePredicate;

public final class FunctionMatchQuery
extends Query {
    static final float DEFAULT_MATCH_COST = 100.0f;
    private final DoubleValuesSource source;
    private final DoublePredicate filter;
    private final float matchCost;

    public FunctionMatchQuery(DoubleValuesSource source, DoublePredicate filter) {
        this(source, filter, 100.0f);
    }

    public FunctionMatchQuery(DoubleValuesSource source, DoublePredicate filter, float matchCost) {
        this.source = source;
        this.filter = filter;
        this.matchCost = matchCost;
    }

    @Override
    public String toString(String field) {
        return "FunctionMatchQuery(" + this.source.toString() + ")";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final DoubleValuesSource vs = this.source.rewrite(searcher);
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final DoubleValues values = vs.getValues(context, null);
                DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    @Override
                    public boolean matches() throws IOException {
                        return values.advanceExact(this.approximation.docID()) && FunctionMatchQuery.this.filter.test(values.doubleValue());
                    }

                    @Override
                    public float matchCost() {
                        return FunctionMatchQuery.this.matchCost;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return FunctionMatchQuery.this.source.isCacheable(ctx);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionMatchQuery that = (FunctionMatchQuery)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.filter, that.filter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.filter);
    }
}

