/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import dev.ftb.mods.ftbquests.config.FTBQuestsTeamConfig;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public class TeamHttpClient {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final HttpClient CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(10L)).build();

    public static CompletableFuture<Boolean> notifyTeamCreated(UUID ownerUuid, String teamName) {
        String apiUrl = FTBQuestsTeamConfig.API_BASE_URL + "teams/";
        JsonObject payload = new JsonObject();
        payload.addProperty("name", teamName);
        payload.addProperty("owner_uuid", ownerUuid.toString());
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((JsonElement)payload))).build();
        return ((CompletableFuture)CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                LOGGER.info("Successfully notified backend of team creation for owner {}", (Object)ownerUuid);
                return true;
            }
            LOGGER.error("Failed to notify backend of team creation for owner {}. Status: {}, Body: {}", new Object[]{ownerUuid, response.statusCode(), response.body()});
            return false;
        })).exceptionally(ex -> {
            LOGGER.error("Exception while notifying backend of team creation for owner {}", (Object)ownerUuid, ex);
            return false;
        });
    }

    public static CompletableFuture<Boolean> notifyIslandAction(UUID playerUuid, String action) {
        String apiUrl = FTBQuestsTeamConfig.API_BASE_URL + "islands/" + playerUuid.toString() + "/" + action;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.noBody()).build();
        return ((CompletableFuture)CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                LOGGER.info("Successfully notified backend of island action '{}' for player {}", (Object)action, (Object)playerUuid);
                return true;
            }
            LOGGER.error("Failed to notify backend of island action '{}' for player {}. Status: {}, Body: {}", new Object[]{action, playerUuid, response.statusCode(), response.body()});
            return false;
        })).exceptionally(ex -> {
            LOGGER.error("Exception during island action '{}' for player {}", new Object[]{action, playerUuid, ex});
            return false;
        });
    }
}

