/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util;

import dev.ftb.mods.ftbquests.util.FTBQuestsInventoryListener;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class DeferredInventoryDetection {
    private static final long MILLIS_IN_TICK = 50L;
    private static final Object2LongOpenHashMap<UUID> playerMap = new Object2LongOpenHashMap();

    public static void tick(MinecraftServer server) {
        if (!playerMap.isEmpty()) {
            HashSet<UUID> toRemove = new HashSet<UUID>();
            long now = System.currentTimeMillis();
            for (UUID id : playerMap.keySet()) {
                if (now < playerMap.getLong((Object)id)) continue;
                ServerPlayer sp = server.m_6846_().m_11259_(id);
                if (sp != null) {
                    FTBQuestsInventoryListener.detect(sp, ItemStack.f_41583_, 0L);
                }
                toRemove.add(id);
            }
            toRemove.forEach(arg_0 -> playerMap.removeLong(arg_0));
        }
    }

    static void scheduleInventoryCheck(ServerPlayer sp, int delay) {
        playerMap.putIfAbsent((Object)sp.m_20148_(), System.currentTimeMillis() + (long)delay * 50L);
    }
}

