/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.team;

import com.mojang.logging.LogUtils;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.quest.team.TeamData;
import dev.ftb.mods.ftbquests.quest.team.TeamRole;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;

public class TeamManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TEAMS_FILE = "ftbquests_teams.snbt";
    private static TeamManager instance;
    private final MinecraftServer server;
    private final Map<UUID, TeamData> teams;
    private final Map<UUID, TeamData> playerTeamMap;
    private final Map<UUID, UUID> invitations;

    private TeamManager(MinecraftServer server) {
        this.server = server;
        this.teams = new HashMap<UUID, TeamData>();
        this.playerTeamMap = new HashMap<UUID, TeamData>();
        this.invitations = new HashMap<UUID, UUID>();
    }

    public static TeamManager getInstance(MinecraftServer server) {
        if (instance == null) {
            instance = new TeamManager(server);
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    private Path getTeamsFilePath() {
        return this.server.m_129843_(LevelResource.f_78182_).resolve("data").resolve(TEAMS_FILE);
    }

    public void load() {
        this.teams.clear();
        this.playerTeamMap.clear();
        this.invitations.clear();
        Path path = this.getTeamsFilePath();
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.info("No FTB Quests teams file found, starting fresh.");
            return;
        }
        try {
            SNBTCompoundTag nbt = SNBT.read((Path)path);
            if (nbt != null && nbt.m_128425_("teams", 9)) {
                ListTag teamsTag = nbt.m_128437_("teams", 10);
                for (Tag tag : teamsTag) {
                    TeamData teamData = TeamData.read((CompoundTag)tag);
                    this.teams.put(teamData.getId(), teamData);
                    for (UUID memberId : teamData.getMembers().keySet()) {
                        this.playerTeamMap.put(memberId, teamData);
                    }
                }
                LOGGER.info("Loaded {} FTB Quests teams.", (Object)this.teams.size());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load FTB Quests teams file", (Throwable)e);
        }
    }

    public void save() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        ListTag teamsTag = new ListTag();
        for (TeamData teamData : this.teams.values()) {
            CompoundTag teamNbt = new CompoundTag();
            teamData.write(teamNbt);
            teamsTag.add((Object)teamNbt);
        }
        nbt.m_128365_("teams", (Tag)teamsTag);
        try {
            SNBT.write((Path)this.getTeamsFilePath(), (CompoundTag)nbt);
            LOGGER.info("Saved {} FTB Quests teams.", (Object)this.teams.size());
        }
        catch (Exception e) {
            LOGGER.error("Failed to save FTB Quests teams file", (Throwable)e);
        }
    }

    public TeamData createTeam(String name, UUID ownerId) {
        if (this.playerTeamMap.containsKey(ownerId)) {
            return null;
        }
        UUID teamId = ownerId;
        TeamData newTeam = new TeamData(teamId, name, ownerId);
        this.teams.put(teamId, newTeam);
        this.playerTeamMap.put(ownerId, newTeam);
        this.save();
        return newTeam;
    }

    public void deleteTeam(UUID teamId) {
        TeamData team = this.teams.remove(teamId);
        if (team != null) {
            for (UUID memberId : team.getMembers().keySet()) {
                this.playerTeamMap.remove(memberId);
            }
            this.save();
        }
    }

    public TeamData getTeam(UUID teamId) {
        return this.teams.get(teamId);
    }

    public Map<UUID, TeamData> getTeams() {
        return Map.copyOf(this.teams);
    }

    public TeamData getPlayerTeam(UUID playerId) {
        return this.playerTeamMap.get(playerId);
    }

    public void addInvitation(UUID invitedPlayer, UUID teamId) {
        this.invitations.put(invitedPlayer, teamId);
    }

    public UUID getInvitation(UUID invitedPlayer) {
        return this.invitations.get(invitedPlayer);
    }

    public boolean addPlayerToTeam(UUID playerId, TeamData team) {
        if (this.playerTeamMap.containsKey(playerId) || !this.teams.containsKey(team.getId())) {
            return false;
        }
        team.addMember(playerId, TeamRole.MEMBER);
        this.playerTeamMap.put(playerId, team);
        this.invitations.remove(playerId);
        this.save();
        return true;
    }

    public TeamData removePlayerFromTeam(UUID playerId) {
        TeamData team = this.getPlayerTeam(playerId);
        if (team != null) {
            if (team.getOwner().equals(playerId)) {
                this.deleteTeam(team.getId());
                return null;
            }
            team.removeMember(playerId);
            this.playerTeamMap.remove(playerId);
            this.save();
        }
        return team;
    }
}

