/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.team;

import dev.ftb.mods.ftbquests.quest.team.TeamRole;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class TeamData {
    private final UUID id;
    private String name;
    private UUID owner;
    private final Map<UUID, TeamRole> members;

    public TeamData(UUID id, String name, UUID owner) {
        this.id = id;
        this.name = name;
        this.owner = owner;
        this.members = new LinkedHashMap<UUID, TeamRole>();
        this.addMember(owner, TeamRole.LEADER);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.members.computeIfPresent(this.owner, (uuid, role) -> TeamRole.MEMBER);
        this.owner = owner;
        this.addMember(owner, TeamRole.LEADER);
    }

    public Map<UUID, TeamRole> getMembers() {
        return Collections.unmodifiableMap(this.members);
    }

    public boolean isMember(UUID playerId) {
        return this.members.containsKey(playerId);
    }

    public void addMember(UUID playerId, TeamRole role) {
        this.members.put(playerId, role);
    }

    public TeamRole removeMember(UUID playerId) {
        if (this.owner.equals(playerId)) {
            throw new IllegalArgumentException("Cannot remove the team owner");
        }
        return this.members.remove(playerId);
    }

    public TeamRole getRole(UUID playerId) {
        return this.members.getOrDefault(playerId, null);
    }

    public void write(CompoundTag nbt) {
        nbt.m_128359_("id", this.id.toString());
        nbt.m_128359_("name", this.name);
        nbt.m_128359_("owner", this.owner.toString());
        ListTag membersTag = new ListTag();
        for (Map.Entry<UUID, TeamRole> entry : this.members.entrySet()) {
            CompoundTag memberTag = new CompoundTag();
            memberTag.m_128359_("uuid", entry.getKey().toString());
            memberTag.m_128359_("role", entry.getValue().name());
            membersTag.add((Object)memberTag);
        }
        nbt.m_128365_("members", (Tag)membersTag);
    }

    public static TeamData read(CompoundTag nbt) {
        UUID id = UUID.fromString(nbt.m_128461_("id"));
        String name = nbt.m_128461_("name");
        UUID owner = UUID.fromString(nbt.m_128461_("owner"));
        TeamData teamData = new TeamData(id, name, owner);
        teamData.members.clear();
        ListTag membersTag = nbt.m_128437_("members", 10);
        for (Tag tag : membersTag) {
            CompoundTag memberTag = (CompoundTag)tag;
            UUID memberUuid = UUID.fromString(memberTag.m_128461_("uuid"));
            TeamRole role = TeamRole.valueOf(memberTag.m_128461_("role"));
            teamData.addMember(memberUuid, role);
        }
        return teamData;
    }
}

