/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.IslandData;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LocationTask
extends AbstractBooleanTask {
    private ResourceKey<Level> dimension = Level.f_46428_;
    private boolean ignoreDimension = false;
    private int x = 0;
    private int y = 0;
    private int z = 0;
    private int w = 1;
    private int h = 1;
    private int d = 1;

    public LocationTask(long id, Quest quest) {
        super(id, quest);
    }

    public void initFromStructure(StructureBlockEntity structure) {
        BlockPos pos = structure.m_59902_();
        Vec3i size = structure.m_155805_();
        this.dimension = structure.m_58904_().m_46472_();
        this.x = pos.m_123341_() + structure.m_58899_().m_123341_();
        this.y = pos.m_123342_() + structure.m_58899_().m_123342_();
        this.z = pos.m_123343_() + structure.m_58899_().m_123343_();
        this.w = Math.max(1, size.m_123341_());
        this.h = Math.max(1, size.m_123342_());
        this.d = Math.max(1, size.m_123343_());
    }

    @Override
    public TaskType getType() {
        return TaskTypes.LOCATION;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("dimension", this.dimension.m_135782_().toString());
        nbt.m_128379_("ignore_dimension", this.ignoreDimension);
        nbt.m_128385_("position", new int[]{this.x, this.y, this.z});
        nbt.m_128385_("size", new int[]{this.w, this.h, this.d});
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dimension")));
        this.ignoreDimension = nbt.m_128471_("ignore_dimension");
        int[] pos = nbt.m_128465_("position");
        if (pos.length == 3) {
            this.x = pos[0];
            this.y = pos[1];
            this.z = pos[2];
        }
        int[] size = nbt.m_128465_("size");
        if (pos.length == 3) {
            this.w = size[0];
            this.h = size[1];
            this.d = size[2];
        }
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130085_(this.dimension.m_135782_());
        buffer.writeBoolean(this.ignoreDimension);
        buffer.m_130130_(this.x);
        buffer.m_130130_(this.y);
        buffer.m_130130_(this.z);
        buffer.m_130130_(this.w);
        buffer.m_130130_(this.h);
        buffer.m_130130_(this.d);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_());
        this.ignoreDimension = buffer.readBoolean();
        this.x = buffer.m_130242_();
        this.y = buffer.m_130242_();
        this.z = buffer.m_130242_();
        this.w = buffer.m_130242_();
        this.h = buffer.m_130242_();
        this.d = buffer.m_130242_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("dim", this.dimension.m_135782_().toString(), v -> {
            this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(v));
        }, "minecraft:overworld");
        config.addBool("ignore_dim", this.ignoreDimension, v -> {
            this.ignoreDimension = v;
        }, false);
        config.addInt("x", this.x, v -> {
            this.x = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("y", this.y, v -> {
            this.y = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("z", this.z, v -> {
            this.z = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("w", this.w, v -> {
            this.w = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addInt("h", this.h, v -> {
            this.h = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addInt("d", this.d, v -> {
            this.d = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 3;
    }

    @Override
    public boolean canSubmit(IslandData islandData, ServerPlayer player) {
        int px;
        int py;
        if ((this.ignoreDimension || this.dimension == player.m_9236_().m_46472_()) && (py = Mth.m_14107_((double)player.m_20186_())) >= this.y && py < this.y + this.h && (px = Mth.m_14107_((double)player.m_20185_())) >= this.x && px < this.x + this.w) {
            int pz = Mth.m_14107_((double)player.m_20189_());
            return pz >= this.z && pz < this.z + this.d;
        }
        return false;
    }
}

